/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.kafka.streams.errors.TopologyException;
import org.apache.kafka.streams.kstream.KeyValueMapper;

public class Printed<K, V> {
    protected final OutputStream outputStream;
    protected String label;
    protected KeyValueMapper<? super K, ? super V, String> mapper = new KeyValueMapper<K, V, String>(){

        @Override
        public String apply(K key, V value) {
            return String.format("%s, %s", key, value);
        }
    };

    private Printed(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    protected Printed(Printed<K, V> printed) {
        this.outputStream = printed.outputStream;
        this.label = printed.label;
        this.mapper = printed.mapper;
    }

    public static <K, V> Printed<K, V> toFile(String filePath) {
        Objects.requireNonNull(filePath, "filePath can't be null");
        if (filePath.trim().isEmpty()) {
            throw new TopologyException("filePath can't be an empty string");
        }
        try {
            return new Printed<K, V>(new FileOutputStream(filePath));
        }
        catch (FileNotFoundException e) {
            throw new TopologyException("Unable to write stream to file at [" + filePath + "] " + e.getMessage());
        }
    }

    public static <K, V> Printed<K, V> toSysOut() {
        return new Printed<K, V>(System.out);
    }

    public Printed<K, V> withLabel(String label) {
        Objects.requireNonNull(label, "label can't be null");
        this.label = label;
        return this;
    }

    public Printed<K, V> withKeyValueMapper(KeyValueMapper<? super K, ? super V, String> mapper) {
        Objects.requireNonNull(mapper, "mapper can't be null");
        this.mapper = mapper;
        return this;
    }
}

