/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map var1, LeafReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
    }

    public static Map newContext(IndexSearcher searcher) {
        IdentityHashMap<String, IndexSearcher> context = new IdentityHashMap<String, IndexSearcher>();
        context.put("searcher", searcher);
        return context;
    }

    public LongValuesSource asLongValuesSource() {
        return new LongValuesSource(){

            public LongValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
                IdentityHashMap<String, FakeScorer> context = new IdentityHashMap<String, FakeScorer>();
                final FakeScorer scorer = new FakeScorer();
                context.put("scorer", scorer);
                final FunctionValues fv = ValueSource.this.getValues(context, ctx);
                return new LongValues(){

                    public long longValue() throws IOException {
                        return fv.longVal(scorer.current);
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        scorer.current = doc;
                        scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                        return fv.exists(doc);
                    }
                };
            }

            public boolean needsScores() {
                return false;
            }
        };
    }

    public DoubleValuesSource asDoubleValuesSource() {
        return new DoubleValuesSource(){

            public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
                HashMap<String, FakeScorer> context = new HashMap<String, FakeScorer>();
                final FakeScorer scorer = new FakeScorer();
                context.put("scorer", scorer);
                final FunctionValues fv = ValueSource.this.getValues(context, ctx);
                return new DoubleValues(){

                    public double doubleValue() throws IOException {
                        return fv.doubleVal(scorer.current);
                    }

                    public boolean advanceExact(int doc) throws IOException {
                        scorer.current = doc;
                        scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                        return fv.exists(doc);
                    }
                };
            }

            public boolean needsScores() {
                return true;
            }
        };
    }

    public SortField getSortField(boolean reverse) {
        return new ValueSourceSortField(reverse);
    }

    class ValueSourceComparator
    extends SimpleFieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map fcontext;
        private double topValue;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        public int compareBottom(int doc) {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        public void copy(int slot, int doc) {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context);
        }

        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        public void setTopValue(Double value) {
            this.topValue = value;
        }

        public Double value(int slot) {
            return this.values[slot];
        }

        public int compareTop(int doc) {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context) {
            this.context = context;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse);
        }

        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map context = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context, searcher);
            return new SortField(this.getField(), (FieldComparatorSource)new ValueSourceComparatorSource(context), this.getReverse());
        }
    }

    private static class FakeScorer
    extends Scorer {
        int current = -1;
        float score = 0.0f;

        FakeScorer() {
            super(null);
        }

        public int docID() {
            return this.current;
        }

        public float score() throws IOException {
            return this.score;
        }

        public int freq() throws IOException {
            throw new UnsupportedOperationException();
        }

        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }
    }
}

