/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.jazz.command.changelog;

import java.util.List;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.jazz.command.consumer.AbstractRepositoryConsumer;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzHistoryConsumer
extends AbstractRepositoryConsumer {
    private static final String CHANGESET_PATTERN = "\\((\\d+)\\) (.*)";
    private RE changeSetRegExp;
    private List<ChangeSet> entries;

    public JazzHistoryConsumer(ScmProviderRepository repo, ScmLogger logger, List<ChangeSet> entries) {
        super(repo, logger);
        this.entries = entries;
        try {
            this.changeSetRegExp = new RE(CHANGESET_PATTERN);
        }
        catch (RESyntaxException ex) {
            throw new RuntimeException("INTERNAL ERROR: Could not create regexp to parse jazz scm history output. This shouldn't happen. Something is probably wrong with the oro installation.", ex);
        }
    }

    @Override
    public void consumeLine(String line) {
        super.consumeLine(line);
        if (this.changeSetRegExp.match(line)) {
            String changesetAlias = this.changeSetRegExp.getParen(1);
            ChangeSet changeSet = new ChangeSet();
            changeSet.setRevision(changesetAlias);
            this.entries.add(changeSet);
        }
    }
}

