/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.surefire.util.ScannerUtil;
import org.apache.maven.plugin.surefire.util.SpecificFileFilter;
import org.apache.maven.surefire.util.DefaultScanResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner {
    private final File basedir;
    private final List<String> includes;
    private final List<String> excludes;
    private final List<String> specificTests;

    public DirectoryScanner(File basedir, List<String> includes, List<String> excludes, List<String> specificTests) {
        this.basedir = basedir;
        this.includes = includes;
        this.excludes = excludes;
        this.specificTests = specificTests;
    }

    public DefaultScanResult scan() {
        String[] specific = this.specificTests == null ? new String[]{} : ScannerUtil.processIncludesExcludes(this.specificTests);
        SpecificFileFilter specificTestFilter = new SpecificFileFilter(specific);
        ArrayList<String> result = new ArrayList<String>();
        if (this.basedir.exists()) {
            org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.DirectoryScanner scanner = new org.apache.maven.surefire.shade.org.apache.maven.shared.utils.io.DirectoryScanner();
            scanner.setBasedir(this.basedir);
            if (this.includes != null) {
                scanner.setIncludes(ScannerUtil.processIncludesExcludes(this.includes));
            }
            if (this.excludes != null) {
                scanner.setExcludes(ScannerUtil.processIncludesExcludes(this.excludes));
            }
            scanner.scan();
            for (String test : scanner.getIncludedFiles()) {
                if (!specificTestFilter.accept(ScannerUtil.stripBaseDir(this.basedir.getAbsolutePath(), test))) continue;
                result.add(ScannerUtil.convertToJavaClassName(test));
            }
        }
        return new DefaultScanResult(result);
    }
}

