/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.shade.org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.maven.surefire.shade.org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.maven.surefire.shade.org.apache.commons.lang.builder.ToStringBuilder;

public class ReportEntry {
    private Object source;
    private String name;
    private String group;
    private String message;
    private StackTraceWriter stackTraceWriter;

    public ReportEntry() {
    }

    public ReportEntry(Object source, String name, String message) {
        this(source, name, null, message);
    }

    public ReportEntry(Object source, String name, String group, String message) {
        this(source, name, group, message, null);
    }

    public ReportEntry(Object source, String name, String message, StackTraceWriter stackTraceWriter) {
        this(source, name, null, message, stackTraceWriter);
    }

    public ReportEntry(Object source, String name, String group, String message, StackTraceWriter stackTraceWriter) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.setSource(source);
        this.setName(name);
        this.setGroup(group);
        this.setMessage(message);
        this.setStackTraceWriter(stackTraceWriter);
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setStackTraceWriter(StackTraceWriter stackTraceWriter) {
        this.stackTraceWriter = stackTraceWriter;
    }

    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReportEntry)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ReportEntry rhs = (ReportEntry)obj;
        return new EqualsBuilder().append(this.getSource(), rhs.getSource()).append(this.getName(), rhs.getName()).append(this.getGroup(), rhs.getGroup()).append(this.getMessage(), rhs.getMessage()).append(this.getStackTraceWriter(), rhs.getStackTraceWriter()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder(this).append("source", this.getSource()).append("name", this.getName()).append("group", this.getGroup()).append("message", this.getMessage()).append("stackTraceWriter", this.getStackTraceWriter()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(5897, 6653).append(this.getSource()).append(this.getName()).append(this.getGroup()).append(this.getMessage()).append(this.getStackTraceWriter()).toHashCode();
    }
}

