/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TimestampConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;

public enum TimestampIndexGranularity {
    MILLISECOND,
    SECOND,
    MINUTE,
    HOUR,
    DAY,
    WEEK,
    MONTH,
    QUARTER,
    YEAR;

    private static final Set<String> VALID_VALUES;

    public static String getColumnNameWithGranularity(String column, TimestampIndexGranularity granularity) {
        return "$" + column + "$" + (Object)((Object)granularity);
    }

    public static boolean isValidTimeColumnWithGranularityName(String columnName) {
        if (columnName.charAt(0) != '$') {
            return false;
        }
        int secondDollarPos = columnName.indexOf(36, 1);
        if (secondDollarPos < 0) {
            return false;
        }
        return VALID_VALUES.contains(columnName.substring(secondDollarPos + 1));
    }

    public static boolean isValidTimeGranularity(String granularity) {
        return VALID_VALUES.contains(granularity);
    }

    public static Set<String> extractTimestampIndexGranularityColumnNames(TableConfig tableConfig) {
        HashSet<String> timeColumnWithGranularity = new HashSet<String>();
        if (tableConfig == null || tableConfig.getFieldConfigList() == null) {
            return timeColumnWithGranularity;
        }
        for (FieldConfig fieldConfig : tableConfig.getFieldConfigList()) {
            TimestampConfig timestampConfig = fieldConfig.getTimestampConfig();
            if (timestampConfig == null || timestampConfig.getGranularities() == null) continue;
            String timeColumn = fieldConfig.getName();
            for (TimestampIndexGranularity granularity : timestampConfig.getGranularities()) {
                timeColumnWithGranularity.add(TimestampIndexGranularity.getColumnNameWithGranularity(timeColumn, granularity));
            }
        }
        return timeColumnWithGranularity;
    }

    @Nullable
    public static FieldSpec getFieldSpecForTimestampColumnWithGranularity(FieldSpec fieldSpec, TimestampIndexGranularity granularity) {
        if (fieldSpec instanceof DateTimeFieldSpec) {
            DateTimeFieldSpec dateTimeFieldSpec = (DateTimeFieldSpec)fieldSpec;
            return new DateTimeFieldSpec(TimestampIndexGranularity.getColumnNameWithGranularity(fieldSpec.getName(), granularity), FieldSpec.DataType.TIMESTAMP, dateTimeFieldSpec.getFormat(), dateTimeFieldSpec.getGranularity());
        }
        return null;
    }

    public static String getTransformExpression(String timeColumn, TimestampIndexGranularity granularity) {
        return "dateTrunc('" + (Object)((Object)granularity) + "', " + timeColumn + ")";
    }

    static {
        VALID_VALUES = Arrays.stream(TimestampIndexGranularity.values()).map(v -> v.toString()).collect(Collectors.toSet());
    }
}

