/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.HashFunction;

public class UpsertConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Upsert mode.")
    private Mode _mode;
    @JsonPropertyDescription(value="Function to hash the primary key.")
    private HashFunction _hashFunction = HashFunction.NONE;
    @JsonPropertyDescription(value="Partial update strategies.")
    private Map<String, Strategy> _partialUpsertStrategies;
    @JsonPropertyDescription(value="default upsert strategy for partial mode")
    private Strategy _defaultPartialUpsertStrategy;
    @JsonPropertyDescription(value="Column for upsert comparison, default to time column")
    private String _comparisonColumn;
    @JsonPropertyDescription(value="Custom class for upsert metadata manager")
    private String _metadataManagerClass;
    @JsonPropertyDescription(value="Custom configs for upsert metadata manager")
    private Map<String, String> _metadataManagerConfigs;

    @Deprecated
    public UpsertConfig(@JsonProperty(value="mode", required=true) Mode mode, @JsonProperty(value="partialUpsertStrategies") @Nullable Map<String, Strategy> partialUpsertStrategies, @JsonProperty(value="defaultPartialUpsertStrategy") @Nullable Strategy defaultPartialUpsertStrategy, @JsonProperty(value="comparisonColumn") @Nullable String comparisonColumn, @JsonProperty(value="hashFunction") @Nullable HashFunction hashFunction) {
        Preconditions.checkArgument((mode != null ? 1 : 0) != 0, (Object)"Upsert mode must be configured");
        this._mode = mode;
        if (mode == Mode.PARTIAL) {
            this._partialUpsertStrategies = partialUpsertStrategies != null ? partialUpsertStrategies : new HashMap();
            this._defaultPartialUpsertStrategy = defaultPartialUpsertStrategy != null ? defaultPartialUpsertStrategy : Strategy.OVERWRITE;
        } else {
            this._partialUpsertStrategies = null;
            this._defaultPartialUpsertStrategy = null;
        }
        this._comparisonColumn = comparisonColumn;
        this._hashFunction = hashFunction == null ? HashFunction.NONE : hashFunction;
    }

    public UpsertConfig(Mode mode) {
        this._mode = mode;
    }

    public UpsertConfig() {
    }

    public Mode getMode() {
        return this._mode;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    @Nullable
    public Map<String, Strategy> getPartialUpsertStrategies() {
        return this._partialUpsertStrategies;
    }

    public Strategy getDefaultPartialUpsertStrategy() {
        return this._defaultPartialUpsertStrategy;
    }

    public String getComparisonColumn() {
        return this._comparisonColumn;
    }

    @Nullable
    public String getMetadataManagerClass() {
        return this._metadataManagerClass;
    }

    @Nullable
    public Map<String, String> getMetadataManagerConfigs() {
        return this._metadataManagerConfigs;
    }

    public void setHashFunction(HashFunction hashFunction) {
        this._hashFunction = hashFunction;
    }

    public void setPartialUpsertStrategies(Map<String, Strategy> partialUpsertStrategies) {
        this._partialUpsertStrategies = partialUpsertStrategies;
    }

    public void setDefaultPartialUpsertStrategy(Strategy defaultPartialUpsertStrategy) {
        this._defaultPartialUpsertStrategy = defaultPartialUpsertStrategy;
    }

    public void setComparisonColumn(String comparisonColumn) {
        this._comparisonColumn = comparisonColumn;
    }

    public void setMetadataManagerClass(String metadataManagerClass) {
        this._metadataManagerClass = metadataManagerClass;
    }

    public void setMetadataManagerConfigs(Map<String, String> metadataManagerConfigs) {
        this._metadataManagerConfigs = metadataManagerConfigs;
    }

    public static enum Strategy {
        APPEND,
        IGNORE,
        INCREMENT,
        OVERWRITE,
        UNION;

    }

    public static enum Mode {
        FULL,
        PARTIAL,
        NONE;

    }
}

