/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatPatternSpec;
import org.apache.pinot.spi.data.DateTimeFormatUnitSpec;
import org.apache.pinot.spi.utils.StringUtil;
import org.apache.pinot.spi.utils.TimestampUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public class DateTimeFormatSpec {
    private static final char COLON_SEPARATOR = ':';
    private static final int COLON_FORMAT_SIZE_POSITION = 0;
    private static final int COLON_FORMAT_TIME_UNIT_POSITION = 1;
    private static final int COLON_FORMAT_TIME_FORMAT_POSITION = 2;
    private static final int COLON_FORMAT_PATTERN_POSITION = 3;
    private static final int COLON_FORMAT_MIN_TOKENS = 3;
    private static final int COLON_FORMAT_MAX_TOKENS = 4;
    private static final char PIPE_SEPARATOR = '|';
    private static final int PIPE_FORMAT_TIME_FORMAT_POSITION = 0;
    private static final int PIPE_FORMAT_TIME_UNIT_POSITION = 1;
    private static final int PIPE_FORMAT_SIZE_POSITION = 2;
    private static final int PIPE_FORMAT_PATTERN_POSITION = 1;
    private static final int PIPE_FORMAT_TIME_ZONE_POSITION = 2;
    private static final int PIPE_FORMAT_MIN_TOKENS = 1;
    private static final int PIPE_FORMAT_MAX_TOKENS = 3;
    private static final DateTimeFormatSpec TIMESTAMP = new DateTimeFormatSpec(1, DateTimeFormatUnitSpec.MILLISECONDS, DateTimeFormatPatternSpec.TIMESTAMP);
    private final int _size;
    private final DateTimeFormatUnitSpec _unitSpec;
    private final DateTimeFormatPatternSpec _patternSpec;

    public DateTimeFormatSpec(String format) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)format), (Object)"Must provide format");
        if (Character.isDigit(format.charAt(0))) {
            DateTimeFieldSpec.TimeFormat timeFormat;
            String[] tokens = StringUtil.split(format, ':', 4);
            Preconditions.checkArgument((tokens.length >= 3 && tokens.length <= 4 ? 1 : 0) != 0, (String)"Invalid format: %s, must be of format 'size:timeUnit:timeFormat(:patternWithTz)'", (Object)format);
            try {
                timeFormat = DateTimeFieldSpec.TimeFormat.valueOf(tokens[2]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid time format: %s in format: %s", tokens[2], format));
            }
            switch (timeFormat) {
                case EPOCH: {
                    String sizeStr = tokens[0];
                    try {
                        this._size = Integer.parseInt(sizeStr);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid size: %s in format: %s", sizeStr, format));
                    }
                    Preconditions.checkArgument((this._size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s in format: %s, must be positive", (int)this._size, (Object)format);
                    String timeUnitStr = tokens[1];
                    try {
                        this._unitSpec = new DateTimeFormatUnitSpec(timeUnitStr);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid time unit: %s in format: %s", timeUnitStr, format));
                    }
                    this._patternSpec = DateTimeFormatPatternSpec.EPOCH;
                    break;
                }
                case TIMESTAMP: {
                    this._size = 1;
                    this._unitSpec = DateTimeFormatUnitSpec.MILLISECONDS;
                    this._patternSpec = DateTimeFormatPatternSpec.TIMESTAMP;
                    break;
                }
                case SIMPLE_DATE_FORMAT: {
                    this._size = 1;
                    this._unitSpec = DateTimeFormatUnitSpec.MILLISECONDS;
                    Preconditions.checkArgument((tokens.length == 4 ? 1 : 0) != 0, (String)"Invalid SIMPLE_DATE_FORMAT format: %s, must be of format '<size>:<timeUnit>:SIMPLE_DATE_FORMAT:<patternWithTz>'", (Object)format);
                    String patternStr = tokens[3];
                    try {
                        this._patternSpec = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, patternStr);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid SIMPLE_DATE_FORMAT pattern: %s in format: %s", patternStr, format));
                    }
                }
                default: {
                    throw new IllegalStateException("Unsupported time format: " + (Object)((Object)timeFormat));
                }
            }
        } else {
            DateTimeFieldSpec.TimeFormat timeFormat;
            String[] tokens = StringUtil.split(format, '|', 3);
            Preconditions.checkArgument((tokens.length >= 1 && tokens.length <= 3 ? 1 : 0) != 0, (String)"Invalid format: %s, must be of format 'EPOCH|<timeUnit>(|<size>)' or 'SIMPLE_DATE_FORMAT|<pattern>(|<timeZone>)' or 'TIMESTAMP'", (Object)format);
            try {
                timeFormat = DateTimeFieldSpec.TimeFormat.valueOf(tokens[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Invalid time format: %s in format: %s", tokens[0], format));
            }
            switch (timeFormat) {
                case EPOCH: {
                    if (tokens.length > 2) {
                        try {
                            this._size = Integer.parseInt(tokens[2]);
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Invalid size: %s in format: %s", tokens[0], format));
                        }
                        Preconditions.checkArgument((this._size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s in format: %s, must be positive", (int)this._size, (Object)format);
                    } else {
                        this._size = 1;
                    }
                    Preconditions.checkArgument((tokens.length > 1 ? 1 : 0) != 0, (String)"Invalid EPOCH format: %s, must be of format 'EPOCH|<timeUnit>(|<size>)'", (Object)format);
                    try {
                        this._unitSpec = new DateTimeFormatUnitSpec(tokens[1]);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid time unit: %s in format: %s", tokens[1], format));
                    }
                    this._patternSpec = DateTimeFormatPatternSpec.EPOCH;
                    break;
                }
                case TIMESTAMP: {
                    this._size = 1;
                    this._unitSpec = DateTimeFormatUnitSpec.MILLISECONDS;
                    this._patternSpec = DateTimeFormatPatternSpec.TIMESTAMP;
                    break;
                }
                case SIMPLE_DATE_FORMAT: {
                    this._size = 1;
                    this._unitSpec = DateTimeFormatUnitSpec.MILLISECONDS;
                    Preconditions.checkArgument((tokens.length > 1 ? 1 : 0) != 0, (String)"Invalid SIMPLE_DATE_FORMAT format: %s, must be of format 'SIMPLE_DATE_FORMAT|<pattern>(|<timeZone>)'", (Object)format);
                    if (tokens.length > 2) {
                        try {
                            this._patternSpec = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, tokens[1], tokens[2]);
                            break;
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException(String.format("Invalid SIMPLE_DATE_FORMAT pattern: %s, time zone: %s in format: %s", tokens[1], tokens[2], format));
                        }
                    }
                    try {
                        this._patternSpec = new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, tokens[1]);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Invalid SIMPLE_DATE_FORMAT pattern: %s in format: %s", tokens[1], format));
                    }
                }
                default: {
                    throw new IllegalStateException("Unsupported time format: " + (Object)((Object)timeFormat));
                }
            }
        }
    }

    private DateTimeFormatSpec(int size, DateTimeFormatUnitSpec unitSpec, DateTimeFormatPatternSpec patternSpec) {
        this._size = size;
        this._unitSpec = unitSpec;
        this._patternSpec = patternSpec;
    }

    public static DateTimeFormatSpec forTimestamp() {
        return TIMESTAMP;
    }

    public static DateTimeFormatSpec forEpoch(String timeUnit) {
        return DateTimeFormatSpec.forEpoch(1, timeUnit);
    }

    public static DateTimeFormatSpec forEpoch(int size, String timeUnit) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: {}, must be positive", (int)size);
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"Must provide time unit");
        return new DateTimeFormatSpec(size, new DateTimeFormatUnitSpec(timeUnit), DateTimeFormatPatternSpec.EPOCH);
    }

    public static DateTimeFormatSpec forSimpleDateFormat(String patternWithTz) {
        return new DateTimeFormatSpec(1, DateTimeFormatUnitSpec.MILLISECONDS, new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, patternWithTz));
    }

    public static DateTimeFormatSpec forSimpleDateFormat(String pattern, @Nullable String timeZone) {
        return new DateTimeFormatSpec(1, DateTimeFormatUnitSpec.MILLISECONDS, new DateTimeFormatPatternSpec(DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT, pattern, timeZone));
    }

    public int getColumnSize() {
        return this._size;
    }

    public TimeUnit getColumnUnit() {
        return this._unitSpec.getTimeUnit();
    }

    public DateTimeFormatUnitSpec.DateTimeTransformUnit getColumnDateTimeTransformUnit() {
        return this._unitSpec.getDateTimeTransformUnit();
    }

    public DateTimeFieldSpec.TimeFormat getTimeFormat() {
        return this._patternSpec.getTimeFormat();
    }

    public String getSDFPattern() {
        return this._patternSpec.getSdfPattern();
    }

    public DateTimeZone getDateTimezone() {
        return this._patternSpec.getDateTimeZone();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this._patternSpec.getDateTimeFormatter();
    }

    public String fromMillisToFormat(long timeMs) {
        switch (this._patternSpec.getTimeFormat()) {
            case EPOCH: {
                return Long.toString(this._unitSpec.getTimeUnit().convert(timeMs, TimeUnit.MILLISECONDS) / (long)this._size);
            }
            case TIMESTAMP: {
                return new Timestamp(timeMs).toString();
            }
            case SIMPLE_DATE_FORMAT: {
                return this._patternSpec.getDateTimeFormatter().print(timeMs);
            }
        }
        throw new IllegalStateException("Unsupported time format: " + (Object)((Object)this._patternSpec.getTimeFormat()));
    }

    public long fromFormatToMillis(String dateTimeValue) {
        switch (this._patternSpec.getTimeFormat()) {
            case EPOCH: {
                return TimeUnit.MILLISECONDS.convert(Long.parseLong(dateTimeValue) * (long)this._size, this._unitSpec.getTimeUnit());
            }
            case TIMESTAMP: {
                return TimestampUtils.toMillisSinceEpoch(dateTimeValue);
            }
            case SIMPLE_DATE_FORMAT: {
                return this._patternSpec.getDateTimeFormatter().parseMillis(dateTimeValue);
            }
        }
        throw new IllegalStateException("Unsupported time format: " + (Object)((Object)this._patternSpec.getTimeFormat()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeFormatSpec that = (DateTimeFormatSpec)o;
        return this._size == that._size && this._unitSpec.equals(that._unitSpec) && this._patternSpec.equals(that._patternSpec);
    }

    public int hashCode() {
        return Objects.hash(this._size, this._unitSpec, this._patternSpec);
    }

    public String toString() {
        return "DateTimeFormatSpec{_size=" + this._size + ", _unitSpec=" + this._unitSpec + ", _patternSpec=" + this._patternSpec + '}';
    }
}

