/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.utils.StringUtil;

public class DateTimeGranularitySpec {
    private static final char SEPARATOR = ':';
    private static final int SIZE_POSITION = 0;
    private static final int TIME_UNIT_POSITION = 1;
    private static final int NUM_TOKENS = 2;
    private final int _size;
    private final TimeUnit _timeUnit;

    public DateTimeGranularitySpec(String granularity) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)granularity), (Object)"Must provide granularity");
        String[] granularityTokens = StringUtil.split(granularity, ':', 2);
        Preconditions.checkArgument((granularityTokens.length >= 2 ? 1 : 0) != 0, (String)"Invalid granularity: %s, must be of format 'size:timeUnit", (Object)granularity);
        try {
            this._size = Integer.parseInt(granularityTokens[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid size: %s in granularity: %s", granularityTokens[0], granularity));
        }
        Preconditions.checkArgument((this._size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s in granularity: %s, must be positive", (int)this._size, (Object)granularity);
        try {
            this._timeUnit = TimeUnit.valueOf(granularityTokens[1]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Invalid time unit: %s in granularity: %s", granularityTokens[1], granularity));
        }
    }

    public DateTimeGranularitySpec(int size, TimeUnit timeUnit) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (String)"Invalid size: %s, must be positive", (int)size);
        Preconditions.checkArgument((timeUnit != null ? 1 : 0) != 0, (Object)"Must provide time unit");
        this._size = size;
        this._timeUnit = timeUnit;
    }

    public int getSize() {
        return this._size;
    }

    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    public long granularityToMillis() {
        return TimeUnit.MILLISECONDS.convert(this._size, this._timeUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateTimeGranularitySpec that = (DateTimeGranularitySpec)o;
        return this._size == that._size && this._timeUnit == that._timeUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this._size, this._timeUnit});
    }
}

