/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import javax.annotation.Nullable;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

public abstract class FieldSpec
implements Comparable<FieldSpec>,
Serializable {
    public static final int DEFAULT_MAX_LENGTH = 512;
    public static final Integer DEFAULT_DIMENSION_NULL_VALUE_OF_INT = Integer.MIN_VALUE;
    public static final Long DEFAULT_DIMENSION_NULL_VALUE_OF_LONG = Long.MIN_VALUE;
    public static final Float DEFAULT_DIMENSION_NULL_VALUE_OF_FLOAT = Float.valueOf(Float.NEGATIVE_INFINITY);
    public static final Double DEFAULT_DIMENSION_NULL_VALUE_OF_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final Integer DEFAULT_DIMENSION_NULL_VALUE_OF_BOOLEAN = 0;
    public static final Long DEFAULT_DIMENSION_NULL_VALUE_OF_TIMESTAMP = 0L;
    public static final String DEFAULT_DIMENSION_NULL_VALUE_OF_STRING = "null";
    public static final String DEFAULT_DIMENSION_NULL_VALUE_OF_JSON = "null";
    public static final byte[] DEFAULT_DIMENSION_NULL_VALUE_OF_BYTES = new byte[0];
    public static final Integer DEFAULT_METRIC_NULL_VALUE_OF_INT = 0;
    public static final Long DEFAULT_METRIC_NULL_VALUE_OF_LONG = 0L;
    public static final Float DEFAULT_METRIC_NULL_VALUE_OF_FLOAT = Float.valueOf(0.0f);
    public static final Double DEFAULT_METRIC_NULL_VALUE_OF_DOUBLE = 0.0;
    public static final BigDecimal DEFAULT_METRIC_NULL_VALUE_OF_BIG_DECIMAL = BigDecimal.ZERO;
    public static final String DEFAULT_METRIC_NULL_VALUE_OF_STRING = "null";
    public static final byte[] DEFAULT_METRIC_NULL_VALUE_OF_BYTES = new byte[0];
    protected String _name;
    protected DataType _dataType;
    protected boolean _isSingleValueField = true;
    private int _maxLength = 512;
    protected Object _defaultNullValue;
    private transient String _stringDefaultNullValue;
    @Deprecated
    protected String _transformFunction;
    protected String _virtualColumnProvider;

    public FieldSpec() {
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField) {
        this(name, dataType, isSingleValueField, 512, null);
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField, @Nullable Object defaultNullValue) {
        this(name, dataType, isSingleValueField, 512, defaultNullValue);
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField, int maxLength, @Nullable Object defaultNullValue) {
        this._name = name;
        this._dataType = dataType;
        this._isSingleValueField = isSingleValueField;
        this._maxLength = maxLength;
        this.setDefaultNullValue(defaultNullValue);
    }

    public abstract FieldType getFieldType();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(DataType dataType) {
        this._dataType = dataType;
        this._defaultNullValue = FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, this._stringDefaultNullValue);
    }

    public boolean isSingleValueField() {
        return this._isSingleValueField;
    }

    public void setSingleValueField(boolean isSingleValueField) {
        this._isSingleValueField = isSingleValueField;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    public String getVirtualColumnProvider() {
        return this._virtualColumnProvider;
    }

    public void setVirtualColumnProvider(String virtualColumnProvider) {
        this._virtualColumnProvider = virtualColumnProvider;
    }

    @JsonIgnore
    public boolean isVirtualColumn() {
        return this._virtualColumnProvider != null && !this._virtualColumnProvider.isEmpty();
    }

    public Object getDefaultNullValue() {
        return this._defaultNullValue;
    }

    public String getDefaultNullValueString() {
        return FieldSpec.getStringValue(this._defaultNullValue);
    }

    protected static String getStringValue(Object value) {
        if (value instanceof byte[]) {
            return BytesUtils.toHexString((byte[])value);
        }
        return value.toString();
    }

    public void setDefaultNullValue(@Nullable Object defaultNullValue) {
        if (defaultNullValue != null) {
            this._stringDefaultNullValue = FieldSpec.getStringValue(defaultNullValue);
        }
        if (this._dataType != null) {
            this._defaultNullValue = FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, this._stringDefaultNullValue);
        }
    }

    public static Object getDefaultNullValue(FieldType fieldType, DataType dataType, @Nullable String stringDefaultNullValue) {
        if (stringDefaultNullValue != null) {
            return dataType.convert(stringDefaultNullValue);
        }
        switch (fieldType) {
            case METRIC: {
                switch (dataType) {
                    case INT: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_INT;
                    }
                    case LONG: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_LONG;
                    }
                    case FLOAT: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_FLOAT;
                    }
                    case DOUBLE: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_DOUBLE;
                    }
                    case BIG_DECIMAL: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_BIG_DECIMAL;
                    }
                    case STRING: {
                        return "null";
                    }
                    case BYTES: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_BYTES;
                    }
                }
                throw new IllegalStateException("Unsupported metric data type: " + (Object)((Object)dataType));
            }
            case DIMENSION: 
            case TIME: 
            case DATE_TIME: {
                switch (dataType) {
                    case INT: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
                    }
                    case LONG: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_LONG;
                    }
                    case FLOAT: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_FLOAT;
                    }
                    case DOUBLE: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_DOUBLE;
                    }
                    case BOOLEAN: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_BOOLEAN;
                    }
                    case TIMESTAMP: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_TIMESTAMP;
                    }
                    case STRING: {
                        return "null";
                    }
                    case JSON: {
                        return "null";
                    }
                    case BYTES: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_BYTES;
                    }
                }
                throw new IllegalStateException("Unsupported dimension/time data type: " + (Object)((Object)dataType));
            }
        }
        throw new IllegalStateException("Unsupported field type: " + (Object)((Object)fieldType));
    }

    @Deprecated
    public String getTransformFunction() {
        return this._transformFunction;
    }

    @Deprecated
    public void setTransformFunction(@Nullable String transformFunction) {
        this._transformFunction = transformFunction;
    }

    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("name", this._name);
        jsonObject.put("dataType", this._dataType.name());
        if (!this._isSingleValueField) {
            jsonObject.put("singleValueField", false);
        }
        if (this._maxLength != 512) {
            jsonObject.put("maxLength", this._maxLength);
        }
        this.appendDefaultNullValue(jsonObject);
        this.appendTransformFunction(jsonObject);
        return jsonObject;
    }

    protected void appendDefaultNullValue(ObjectNode jsonNode) {
        assert (this._defaultNullValue != null);
        String key = "defaultNullValue";
        if (!this._defaultNullValue.equals(FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, null))) {
            switch (this._dataType) {
                case INT: {
                    jsonNode.put(key, (Integer)this._defaultNullValue);
                    break;
                }
                case LONG: {
                    jsonNode.put(key, (Long)this._defaultNullValue);
                    break;
                }
                case FLOAT: {
                    jsonNode.put(key, (Float)this._defaultNullValue);
                    break;
                }
                case DOUBLE: {
                    jsonNode.put(key, (Double)this._defaultNullValue);
                    break;
                }
                case BIG_DECIMAL: {
                    jsonNode.put(key, (BigDecimal)this._defaultNullValue);
                    break;
                }
                case BOOLEAN: {
                    jsonNode.put(key, (Integer)this._defaultNullValue == 1);
                    break;
                }
                case TIMESTAMP: {
                    jsonNode.put(key, new Timestamp((Long)this._defaultNullValue).toString());
                    break;
                }
                case STRING: 
                case JSON: {
                    jsonNode.put(key, (String)this._defaultNullValue);
                    break;
                }
                case BYTES: {
                    jsonNode.put(key, BytesUtils.toHexString((byte[])this._defaultNullValue));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + this);
                }
            }
        }
    }

    protected void appendTransformFunction(ObjectNode jsonNode) {
        if (this._transformFunction != null) {
            jsonNode.put("transformFunction", this._transformFunction);
        }
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        FieldSpec that = (FieldSpec)o;
        return EqualityUtils.isEqual(this._name, that._name) && EqualityUtils.isEqual((Object)this._dataType, (Object)that._dataType) && EqualityUtils.isEqual(this._isSingleValueField, that._isSingleValueField) && EqualityUtils.isEqual(FieldSpec.getStringValue(this._defaultNullValue), FieldSpec.getStringValue(that._defaultNullValue)) && EqualityUtils.isEqual(this._maxLength, that._maxLength) && EqualityUtils.isEqual(this._transformFunction, that._transformFunction) && EqualityUtils.isEqual(this._virtualColumnProvider, that._virtualColumnProvider);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._name);
        result = EqualityUtils.hashCodeOf(result, (Object)this._dataType);
        result = EqualityUtils.hashCodeOf(result, this._isSingleValueField);
        result = EqualityUtils.hashCodeOf(result, FieldSpec.getStringValue(this._defaultNullValue));
        result = EqualityUtils.hashCodeOf(result, this._maxLength);
        result = EqualityUtils.hashCodeOf(result, this._transformFunction);
        result = EqualityUtils.hashCodeOf(result, this._virtualColumnProvider);
        return result;
    }

    @Override
    public int compareTo(FieldSpec otherSpec) {
        return this._name.compareTo(otherSpec._name);
    }

    public static enum DataType {
        INT(4, true, true),
        LONG(8, true, true),
        FLOAT(4, true, true),
        DOUBLE(8, true, true),
        BIG_DECIMAL(true, true),
        BOOLEAN(INT, false, true),
        TIMESTAMP(LONG, false, true),
        STRING(false, true),
        JSON(STRING, false, false),
        BYTES(false, false),
        STRUCT(false, false),
        MAP(false, false),
        LIST(false, false);

        private final DataType _storedType;
        private final int _size;
        private final boolean _sortable;
        private final boolean _numeric;

        private DataType(boolean numeric, boolean sortable) {
            this._storedType = this;
            this._size = -1;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        private DataType(DataType storedType, boolean numeric, boolean sortable) {
            this._storedType = storedType;
            this._size = storedType._size;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        private DataType(int size, boolean numeric, boolean sortable) {
            this._storedType = this;
            this._size = size;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        public DataType getStoredType() {
            return this._storedType;
        }

        public boolean isFixedWidth() {
            return this._size >= 0;
        }

        public int size() {
            if (this._size >= 0) {
                return this._size;
            }
            throw new IllegalStateException("Cannot get number of bytes for: " + (Object)((Object)this));
        }

        public boolean isNumeric() {
            return this._numeric;
        }

        public Object convert(String value) {
            try {
                switch (this) {
                    case INT: {
                        return Integer.valueOf(value);
                    }
                    case LONG: {
                        return Long.valueOf(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE: {
                        return Double.valueOf(value);
                    }
                    case BIG_DECIMAL: {
                        return new BigDecimal(value);
                    }
                    case BOOLEAN: {
                        return BooleanUtils.toInt(value);
                    }
                    case TIMESTAMP: {
                        return TimestampUtils.toMillisSinceEpoch(value);
                    }
                    case STRING: 
                    case JSON: {
                        return value;
                    }
                    case BYTES: {
                        return BytesUtils.toBytes(value);
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot convert value: '%s' to type: %s", new Object[]{value, this}));
            }
        }

        public Comparable convertInternal(String value) {
            try {
                switch (this) {
                    case INT: {
                        return Integer.valueOf(value);
                    }
                    case LONG: {
                        return Long.valueOf(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE: {
                        return Double.valueOf(value);
                    }
                    case BIG_DECIMAL: {
                        return new BigDecimal(value);
                    }
                    case BOOLEAN: {
                        return Integer.valueOf(BooleanUtils.toInt(value));
                    }
                    case TIMESTAMP: {
                        return Long.valueOf(TimestampUtils.toMillisSinceEpoch(value));
                    }
                    case STRING: 
                    case JSON: {
                        return value;
                    }
                    case BYTES: {
                        return BytesUtils.toByteArray(value);
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Cannot convert value: '%s' to type: %s", new Object[]{value, this}));
            }
        }

        public boolean canBeASortedColumn() {
            return this._sortable;
        }
    }

    public static enum FieldType {
        DIMENSION,
        METRIC,
        TIME,
        DATE_TIME,
        COMPLEX;

    }
}

