/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.filesystem;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.env.PinotConfiguration;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface PinotFS
extends Closeable,
Serializable {
    public void init(PinotConfiguration var1);

    public boolean mkdir(URI var1) throws IOException;

    public boolean delete(URI var1, boolean var2) throws IOException;

    public boolean move(URI var1, URI var2, boolean var3) throws IOException;

    default public boolean copy(URI srcUri, URI dstUri) throws IOException {
        if (this.isDirectory(srcUri)) {
            throw new IllegalArgumentException("Recursive copy not supported");
        }
        return this.copyDir(srcUri, dstUri);
    }

    public boolean copyDir(URI var1, URI var2) throws IOException;

    public boolean exists(URI var1) throws IOException;

    public long length(URI var1) throws IOException;

    public String[] listFiles(URI var1, boolean var2) throws IOException;

    public void copyToLocalFile(URI var1, File var2) throws Exception;

    default public void copyFromLocalDir(File srcFile, URI dstUri) throws Exception {
        throw new UnsupportedOperationException("Recursive copy not supported");
    }

    public void copyFromLocalFile(File var1, URI var2) throws Exception;

    public boolean isDirectory(URI var1) throws IOException;

    public long lastModified(URI var1) throws IOException;

    public boolean touch(URI var1) throws IOException;

    public InputStream open(URI var1) throws IOException;

    @Override
    default public void close() throws IOException {
    }
}

