/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.plugin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PluginClassLoader
extends URLClassLoader {
    private final ClassLoader _classLoader = PluginClassLoader.class.getClassLoader();
    private Method _addUrlMethod = null;

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        if (this._classLoader instanceof URLClassLoader) {
            try {
                this._addUrlMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            }
            catch (NoSuchMethodException e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
            this._addUrlMethod.setAccessible(true);
        }
        for (URL url : urls) {
            try {
                this.addURL(url);
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    @Override
    protected void addURL(URL url) {
        if (this._addUrlMethod != null) {
            try {
                this._addUrlMethod.invoke((Object)this._classLoader, url);
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        } else {
            super.addURL(url);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                if (this._classLoader != null) {
                    loadedClass = this._classLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (loadedClass == null) {
                    loadedClass = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                loadedClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        Enumeration<URL> thisRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> sysResources = this._classLoader.getResources(name);
        if (sysResources != null) {
            while (sysResources.hasMoreElements()) {
                allRes.add(sysResources.nextElement());
            }
        }
        if ((thisRes = this.findResources(name)) != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> _it;
            {
                this._it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this._it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this._it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = null;
        if (this._classLoader != null) {
            res = this._classLoader.getResource(name);
        }
        if (res == null) {
            res = this.findResource(name);
        }
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }
}

