/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util.ignore;

import java.io.File;
import java.util.Optional;
import nl.basjes.gitignore.GitIgnoreFileSet;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.mp.util.ignore.IgnoreMatcher;

public class GitIgnoreMatcher
implements IgnoreMatcher {
    private final GitIgnoreFileSet gitIgnoreFileSet;

    public GitIgnoreMatcher(Log log, File projectBaseDir) {
        log.debug((CharSequence)("Recursively loading .gitignore files in " + projectBaseDir));
        this.gitIgnoreFileSet = new GitIgnoreFileSet(projectBaseDir);
    }

    @Override
    public boolean isEmpty() {
        return this.gitIgnoreFileSet.isEmpty();
    }

    @Override
    public Optional<Boolean> isIgnoredFile(String filename) {
        Boolean isIgnoredFile = this.gitIgnoreFileSet.isIgnoredFile(filename);
        if (isIgnoredFile == null) {
            return Optional.empty();
        }
        return Optional.of(isIgnoredFile);
    }

    public String toString() {
        return "Loaded .gitignore data:\n" + this.gitIgnoreFileSet;
    }
}

