/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util.ignore;

import java.util.ArrayList;
import java.util.List;
import org.apache.rat.mp.util.ignore.IgnoreMatcher;
import org.codehaus.plexus.util.DirectoryScanner;

public class IgnoringDirectoryScanner
extends DirectoryScanner {
    List<IgnoreMatcher> ignoreMatcherList = new ArrayList<IgnoreMatcher>();

    public void addIgnoreMatcher(IgnoreMatcher ignoreMatcher) {
        this.ignoreMatcherList.add(ignoreMatcher);
    }

    private boolean matchesAnIgnoreMatcher(String name) {
        for (IgnoreMatcher ignoreMatcher : this.ignoreMatcherList) {
            if (ignoreMatcher.isIgnoredFile(name).orElse(Boolean.FALSE) != Boolean.TRUE) continue;
            return true;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        if (this.matchesAnIgnoreMatcher(name)) {
            return true;
        }
        return super.isExcluded(name);
    }

    protected boolean isExcluded(String name, String[] tokenizedName) {
        if (this.matchesAnIgnoreMatcher(name)) {
            return true;
        }
        return super.isExcluded(name, tokenizedName);
    }

    protected boolean isExcluded(String name, char[][] tokenizedName) {
        if (this.matchesAnIgnoreMatcher(name)) {
            return true;
        }
        return super.isExcluded(name, tokenizedName);
    }
}

