/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;

public class GrpcAdminProtocolService
extends AdminProtocolServiceGrpc.AdminProtocolServiceImplBase {
    private final AdminAsynchronousProtocol protocol;

    public GrpcAdminProtocolService(AdminAsynchronousProtocol protocol) {
        this.protocol = protocol;
    }

    public void groupManagement(RaftProtos.GroupManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        GroupManagementRequest request = ClientProtoUtils.toGroupManagementRequest((RaftProtos.GroupManagementRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.groupManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    public void groupList(RaftProtos.GroupListRequestProto proto, StreamObserver<RaftProtos.GroupListReplyProto> responseObserver) {
        GroupListRequest request = ClientProtoUtils.toGroupListRequest((RaftProtos.GroupListRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupListAsync(request), ClientProtoUtils::toGroupListReplyProto);
    }

    public void groupInfo(RaftProtos.GroupInfoRequestProto proto, StreamObserver<RaftProtos.GroupInfoReplyProto> responseObserver) {
        GroupInfoRequest request = ClientProtoUtils.toGroupInfoRequest((RaftProtos.GroupInfoRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupInfoAsync(request), ClientProtoUtils::toGroupInfoReplyProto);
    }

    public void setConfiguration(RaftProtos.SetConfigurationRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.setConfigurationAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }

    public void transferLeadership(RaftProtos.TransferLeadershipRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        TransferLeadershipRequest request = ClientProtoUtils.toTransferLeadershipRequest((RaftProtos.TransferLeadershipRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.transferLeadershipAsync(request), ClientProtoUtils::toRaftClientReplyProto);
    }
}

