/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.namesrv;

import java.io.IOException;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.utils.HttpTinyClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopAddressing {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String nsAddr;
    private String wsAddr;
    private String unitName;

    public TopAddressing(String wsAddr) {
        this(wsAddr, null);
    }

    public TopAddressing(String wsAddr, String unitName) {
        this.wsAddr = wsAddr;
        this.unitName = unitName;
    }

    private static String clearNewLine(String str) {
        String newString = str.trim();
        int index = newString.indexOf("\r");
        if (index != -1) {
            return newString.substring(0, index);
        }
        index = newString.indexOf("\n");
        if (index != -1) {
            return newString.substring(0, index);
        }
        return newString;
    }

    public final String fetchNSAddr() {
        return this.fetchNSAddr(true, 3000L);
    }

    public final String fetchNSAddr(boolean verbose, long timeoutMills) {
        String url;
        block7: {
            url = this.wsAddr;
            try {
                if (!UtilAll.isBlank(this.unitName)) {
                    url = url + "-" + this.unitName + "?nofix=1";
                }
                HttpTinyClient.HttpResult result = HttpTinyClient.httpGet(url, null, null, "UTF-8", timeoutMills);
                if (200 == result.code) {
                    String responseStr = result.content;
                    if (responseStr != null) {
                        return TopAddressing.clearNewLine(responseStr);
                    }
                    log.error("fetch nameserver address is null");
                } else {
                    log.error("fetch nameserver address failed. statusCode={}", (Object)result.code);
                }
            }
            catch (IOException e) {
                if (!verbose) break block7;
                log.error("fetch name server address exception", (Throwable)e);
            }
        }
        if (verbose) {
            String errorMsg = "connect to " + url + " failed, maybe the domain name " + MixAll.getWSAddr() + " not bind in /etc/hosts";
            errorMsg = errorMsg + FAQUrl.suggestTodo("http://rocketmq.apache.org/docs/faq/");
            log.warn(errorMsg);
        }
        return null;
    }

    public String getNsAddr() {
        return this.nsAddr;
    }

    public void setNsAddr(String nsAddr) {
        this.nsAddr = nsAddr;
    }
}

