/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageExtBatch;
import org.apache.rocketmq.store.AppendMessageCallback;
import org.apache.rocketmq.store.AppendMessageResult;
import org.apache.rocketmq.store.AppendMessageStatus;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.ReferenceResource;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.TransientStorePool;
import org.apache.rocketmq.store.config.FlushDiskType;
import org.apache.rocketmq.store.util.LibC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.nio.ch.DirectBuffer;

public class MappedFile
extends ReferenceResource {
    public static final int OS_PAGE_SIZE = 4096;
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final AtomicLong TOTAL_MAPPED_VIRTUAL_MEMORY = new AtomicLong(0L);
    private static final AtomicInteger TOTAL_MAPPED_FILES = new AtomicInteger(0);
    protected final AtomicInteger wrotePosition = new AtomicInteger(0);
    protected final AtomicInteger committedPosition = new AtomicInteger(0);
    private final AtomicInteger flushedPosition = new AtomicInteger(0);
    protected int fileSize;
    protected FileChannel fileChannel;
    protected ByteBuffer writeBuffer = null;
    protected TransientStorePool transientStorePool = null;
    private String fileName;
    private long fileFromOffset;
    private File file;
    private MappedByteBuffer mappedByteBuffer;
    private volatile long storeTimestamp = 0L;
    private boolean firstCreateInQueue = false;

    public MappedFile() {
    }

    public MappedFile(String fileName, int fileSize) throws IOException {
        this.init(fileName, fileSize);
    }

    public MappedFile(String fileName, int fileSize, TransientStorePool transientStorePool) throws IOException {
        this.init(fileName, fileSize, transientStorePool);
    }

    public static void ensureDirOK(String dirName) {
        File f;
        if (dirName != null && !(f = new File(dirName)).exists()) {
            boolean result = f.mkdirs();
            log.info(dirName + " mkdir " + (result ? "OK" : "Failed"));
        }
    }

    public static void clean(ByteBuffer buffer) {
        if (buffer == null || !buffer.isDirect() || buffer.capacity() == 0) {
            return;
        }
        MappedFile.invoke(MappedFile.invoke(MappedFile.viewed(buffer), "cleaner", new Class[0]), "clean", new Class[0]);
    }

    private static Object invoke(final Object target, final String methodName, final Class<?> ... args) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = MappedFile.method(target, methodName, args);
                    method.setAccessible(true);
                    return method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private static Method method(Object target, String methodName, Class<?>[] args) throws NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodName, args);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getDeclaredMethod(methodName, args);
        }
    }

    private static ByteBuffer viewed(ByteBuffer buffer) {
        ByteBuffer viewedBuffer;
        String methodName = "viewedBuffer";
        Method[] methods = buffer.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals("attachment")) continue;
            methodName = "attachment";
            break;
        }
        if ((viewedBuffer = (ByteBuffer)MappedFile.invoke(buffer, methodName, new Class[0])) == null) {
            return buffer;
        }
        return MappedFile.viewed(viewedBuffer);
    }

    public static int getTotalMappedFiles() {
        return TOTAL_MAPPED_FILES.get();
    }

    public static long getTotalMappedVirtualMemory() {
        return TOTAL_MAPPED_VIRTUAL_MEMORY.get();
    }

    public void init(String fileName, int fileSize, TransientStorePool transientStorePool) throws IOException {
        this.init(fileName, fileSize);
        this.writeBuffer = transientStorePool.borrowBuffer();
        this.transientStorePool = transientStorePool;
    }

    private void init(String fileName, int fileSize) throws IOException {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.file = new File(fileName);
        this.fileFromOffset = Long.parseLong(this.file.getName());
        boolean ok = false;
        MappedFile.ensureDirOK(this.file.getParent());
        try {
            this.fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.mappedByteBuffer = this.fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize);
            TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(fileSize);
            TOTAL_MAPPED_FILES.incrementAndGet();
            ok = true;
        }
        catch (FileNotFoundException e) {
            log.error("create file channel " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            log.error("map file " + this.fileName + " Failed. ", (Throwable)e);
            throw e;
        }
        finally {
            if (!ok && this.fileChannel != null) {
                this.fileChannel.close();
            }
        }
    }

    public long getLastModifiedTimestamp() {
        return this.file.lastModified();
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public FileChannel getFileChannel() {
        return this.fileChannel;
    }

    public AppendMessageResult appendMessage(MessageExtBrokerInner msg, AppendMessageCallback cb) {
        return this.appendMessagesInner(msg, cb);
    }

    public AppendMessageResult appendMessages(MessageExtBatch messageExtBatch, AppendMessageCallback cb) {
        return this.appendMessagesInner((MessageExt)messageExtBatch, cb);
    }

    public AppendMessageResult appendMessagesInner(MessageExt messageExt, AppendMessageCallback cb) {
        assert (messageExt != null);
        assert (cb != null);
        int currentPos = this.wrotePosition.get();
        if (currentPos < this.fileSize) {
            ByteBuffer byteBuffer = this.writeBuffer != null ? this.writeBuffer.slice() : this.mappedByteBuffer.slice();
            byteBuffer.position(currentPos);
            AppendMessageResult result = null;
            if (messageExt instanceof MessageExtBrokerInner) {
                result = cb.doAppend(this.getFileFromOffset(), byteBuffer, this.fileSize - currentPos, (MessageExtBrokerInner)messageExt);
            } else if (messageExt instanceof MessageExtBatch) {
                result = cb.doAppend(this.getFileFromOffset(), byteBuffer, this.fileSize - currentPos, (MessageExtBatch)messageExt);
            } else {
                return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
            }
            this.wrotePosition.addAndGet(result.getWroteBytes());
            this.storeTimestamp = result.getStoreTimestamp();
            return result;
        }
        log.error("MappedFile.appendMessage return null, wrotePosition: {} fileSize: {}", (Object)currentPos, (Object)this.fileSize);
        return new AppendMessageResult(AppendMessageStatus.UNKNOWN_ERROR);
    }

    public long getFileFromOffset() {
        return this.fileFromOffset;
    }

    public boolean appendMessage(byte[] data) {
        int currentPos = this.wrotePosition.get();
        if (currentPos + data.length <= this.fileSize) {
            try {
                this.fileChannel.position(currentPos);
                this.fileChannel.write(ByteBuffer.wrap(data));
            }
            catch (Throwable e) {
                log.error("Error occurred when append message to mappedFile.", e);
            }
            this.wrotePosition.addAndGet(data.length);
            return true;
        }
        return false;
    }

    public boolean appendMessage(byte[] data, int offset, int length) {
        int currentPos = this.wrotePosition.get();
        if (currentPos + length <= this.fileSize) {
            try {
                this.fileChannel.position(currentPos);
                this.fileChannel.write(ByteBuffer.wrap(data, offset, length));
            }
            catch (Throwable e) {
                log.error("Error occurred when append message to mappedFile.", e);
            }
            this.wrotePosition.addAndGet(length);
            return true;
        }
        return false;
    }

    public int flush(int flushLeastPages) {
        if (this.isAbleToFlush(flushLeastPages)) {
            if (this.hold()) {
                int value = this.getReadPosition();
                try {
                    if (this.writeBuffer != null || this.fileChannel.position() != 0L) {
                        this.fileChannel.force(false);
                    } else {
                        this.mappedByteBuffer.force();
                    }
                }
                catch (Throwable e) {
                    log.error("Error occurred when force data to disk.", e);
                }
                this.flushedPosition.set(value);
                this.release();
            } else {
                log.warn("in flush, hold failed, flush offset = " + this.flushedPosition.get());
                this.flushedPosition.set(this.getReadPosition());
            }
        }
        return this.getFlushedPosition();
    }

    public int commit(int commitLeastPages) {
        if (this.writeBuffer == null) {
            return this.wrotePosition.get();
        }
        if (this.isAbleToCommit(commitLeastPages)) {
            if (this.hold()) {
                this.commit0(commitLeastPages);
                this.release();
            } else {
                log.warn("in commit, hold failed, commit offset = " + this.committedPosition.get());
            }
        }
        if (this.writeBuffer != null && this.transientStorePool != null && this.fileSize == this.committedPosition.get()) {
            this.transientStorePool.returnBuffer(this.writeBuffer);
            this.writeBuffer = null;
        }
        return this.committedPosition.get();
    }

    protected void commit0(int commitLeastPages) {
        int writePos = this.wrotePosition.get();
        int lastCommittedPosition = this.committedPosition.get();
        if (writePos - this.committedPosition.get() > 0) {
            try {
                ByteBuffer byteBuffer = this.writeBuffer.slice();
                byteBuffer.position(lastCommittedPosition);
                byteBuffer.limit(writePos);
                this.fileChannel.position(lastCommittedPosition);
                this.fileChannel.write(byteBuffer);
                this.committedPosition.set(writePos);
            }
            catch (Throwable e) {
                log.error("Error occurred when commit data to FileChannel.", e);
            }
        }
    }

    private boolean isAbleToFlush(int flushLeastPages) {
        int flush = this.flushedPosition.get();
        int write = this.getReadPosition();
        if (this.isFull()) {
            return true;
        }
        if (flushLeastPages > 0) {
            return write / 4096 - flush / 4096 >= flushLeastPages;
        }
        return write > flush;
    }

    protected boolean isAbleToCommit(int commitLeastPages) {
        int flush = this.committedPosition.get();
        int write = this.wrotePosition.get();
        if (this.isFull()) {
            return true;
        }
        if (commitLeastPages > 0) {
            return write / 4096 - flush / 4096 >= commitLeastPages;
        }
        return write > flush;
    }

    public int getFlushedPosition() {
        return this.flushedPosition.get();
    }

    public void setFlushedPosition(int pos) {
        this.flushedPosition.set(pos);
    }

    public boolean isFull() {
        return this.fileSize == this.wrotePosition.get();
    }

    public SelectMappedBufferResult selectMappedBuffer(int pos, int size) {
        int readPosition = this.getReadPosition();
        if (pos + size <= readPosition) {
            if (this.hold()) {
                ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
                byteBuffer.position(pos);
                ByteBuffer byteBufferNew = byteBuffer.slice();
                byteBufferNew.limit(size);
                return new SelectMappedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
            }
            log.warn("matched, but hold failed, request pos: " + pos + ", fileFromOffset: " + this.fileFromOffset);
        } else {
            log.warn("selectMappedBuffer request pos invalid, request pos: " + pos + ", size: " + size + ", fileFromOffset: " + this.fileFromOffset);
        }
        return null;
    }

    public SelectMappedBufferResult selectMappedBuffer(int pos) {
        int readPosition = this.getReadPosition();
        if (pos < readPosition && pos >= 0 && this.hold()) {
            ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
            byteBuffer.position(pos);
            int size = readPosition - pos;
            ByteBuffer byteBufferNew = byteBuffer.slice();
            byteBufferNew.limit(size);
            return new SelectMappedBufferResult(this.fileFromOffset + (long)pos, byteBufferNew, size, this);
        }
        return null;
    }

    @Override
    public boolean cleanup(long currentRef) {
        if (this.isAvailable()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have not shutdown, stop unmapping.");
            return false;
        }
        if (this.isCleanupOver()) {
            log.error("this file[REF:" + currentRef + "] " + this.fileName + " have cleanup, do not do it again.");
            return true;
        }
        MappedFile.clean(this.mappedByteBuffer);
        TOTAL_MAPPED_VIRTUAL_MEMORY.addAndGet(this.fileSize * -1);
        TOTAL_MAPPED_FILES.decrementAndGet();
        log.info("unmap file[REF:" + currentRef + "] " + this.fileName + " OK");
        return true;
    }

    public boolean destroy(long intervalForcibly) {
        this.shutdown(intervalForcibly);
        if (this.isCleanupOver()) {
            try {
                this.fileChannel.close();
                log.info("close file channel " + this.fileName + " OK");
                long beginTime = System.currentTimeMillis();
                boolean result = this.file.delete();
                log.info("delete file[REF:" + this.getRefCount() + "] " + this.fileName + (result ? " OK, " : " Failed, ") + "W:" + this.getWrotePosition() + " M:" + this.getFlushedPosition() + ", " + UtilAll.computeEclipseTimeMilliseconds((long)beginTime));
            }
            catch (Exception e) {
                log.warn("close file channel " + this.fileName + " Failed. ", (Throwable)e);
            }
            return true;
        }
        log.warn("destroy mapped file[REF:" + this.getRefCount() + "] " + this.fileName + " Failed. cleanupOver: " + this.cleanupOver);
        return false;
    }

    public int getWrotePosition() {
        return this.wrotePosition.get();
    }

    public void setWrotePosition(int pos) {
        this.wrotePosition.set(pos);
    }

    public int getReadPosition() {
        return this.writeBuffer == null ? this.wrotePosition.get() : this.committedPosition.get();
    }

    public void setCommittedPosition(int pos) {
        this.committedPosition.set(pos);
    }

    public void warmMappedFile(FlushDiskType type, int pages) {
        long beginTime = System.currentTimeMillis();
        ByteBuffer byteBuffer = this.mappedByteBuffer.slice();
        int flush = 0;
        long time = System.currentTimeMillis();
        int i = 0;
        int j = 0;
        while (i < this.fileSize) {
            byteBuffer.put(i, (byte)0);
            if (type == FlushDiskType.SYNC_FLUSH && i / 4096 - flush / 4096 >= pages) {
                flush = i;
                this.mappedByteBuffer.force();
            }
            if (j % 1000 == 0) {
                log.info("j={}, costTime={}", (Object)j, (Object)(System.currentTimeMillis() - time));
                time = System.currentTimeMillis();
                try {
                    Thread.sleep(0L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            i += 4096;
            ++j;
        }
        if (type == FlushDiskType.SYNC_FLUSH) {
            log.info("mapped file warm-up done, force to disk, mappedFile={}, costTime={}", (Object)this.getFileName(), (Object)(System.currentTimeMillis() - beginTime));
            this.mappedByteBuffer.force();
        }
        log.info("mapped file warm-up done. mappedFile={}, costTime={}", (Object)this.getFileName(), (Object)(System.currentTimeMillis() - beginTime));
        this.mlock();
    }

    public String getFileName() {
        return this.fileName;
    }

    public MappedByteBuffer getMappedByteBuffer() {
        return this.mappedByteBuffer;
    }

    public ByteBuffer sliceByteBuffer() {
        return this.mappedByteBuffer.slice();
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public boolean isFirstCreateInQueue() {
        return this.firstCreateInQueue;
    }

    public void setFirstCreateInQueue(boolean firstCreateInQueue) {
        this.firstCreateInQueue = firstCreateInQueue;
    }

    public void mlock() {
        long beginTime = System.currentTimeMillis();
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        int ret = LibC.INSTANCE.mlock(pointer, new NativeLong((long)this.fileSize));
        log.info("mlock {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
        ret = LibC.INSTANCE.madvise(pointer, new NativeLong((long)this.fileSize), 3);
        log.info("madvise {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
    }

    public void munlock() {
        long beginTime = System.currentTimeMillis();
        long address = ((DirectBuffer)((Object)this.mappedByteBuffer)).address();
        Pointer pointer = new Pointer(address);
        int ret = LibC.INSTANCE.munlock(pointer, new NativeLong((long)this.fileSize));
        log.info("munlock {} {} {} ret = {} time consuming = {}", new Object[]{address, this.fileName, this.fileSize, ret, System.currentTimeMillis() - beginTime});
    }

    public String toString() {
        return this.fileName;
    }
}

