/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.rocketmq.common.ServiceThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreStatsService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final int FREQUENCY_OF_SAMPLING = 1000;
    private static final int MAX_RECORDS_OF_SAMPLING = 600;
    private static final String[] PUT_MESSAGE_ENTIRE_TIME_MAX_DESC = new String[]{"[<=0ms]", "[0~10ms]", "[10~50ms]", "[50~100ms]", "[100~200ms]", "[200~500ms]", "[500ms~1s]", "[1~2s]", "[2~3s]", "[3~4s]", "[4~5s]", "[5~10s]", "[10s~]"};
    private static int printTPSInterval = 60;
    private final AtomicLong putMessageFailedTimes = new AtomicLong(0L);
    private final Map<String, AtomicLong> putMessageTopicTimesTotal = new ConcurrentHashMap<String, AtomicLong>(128);
    private final Map<String, AtomicLong> putMessageTopicSizeTotal = new ConcurrentHashMap<String, AtomicLong>(128);
    private final AtomicLong getMessageTimesTotalFound = new AtomicLong(0L);
    private final AtomicLong getMessageTransferedMsgCount = new AtomicLong(0L);
    private final AtomicLong getMessageTimesTotalMiss = new AtomicLong(0L);
    private final LinkedList<CallSnapshot> putTimesList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesFoundList = new LinkedList();
    private final LinkedList<CallSnapshot> getTimesMissList = new LinkedList();
    private final LinkedList<CallSnapshot> transferedMsgCountList = new LinkedList();
    private volatile AtomicLong[] putMessageDistributeTime;
    private long messageStoreBootTimestamp = System.currentTimeMillis();
    private volatile long putMessageEntireTimeMax = 0L;
    private volatile long getMessageEntireTimeMax = 0L;
    private ReentrantLock lockPut = new ReentrantLock();
    private ReentrantLock lockGet = new ReentrantLock();
    private volatile long dispatchMaxBuffer = 0L;
    private ReentrantLock lockSampling = new ReentrantLock();
    private long lastPrintTimestamp = System.currentTimeMillis();

    public StoreStatsService() {
        this.initPutMessageDistributeTime();
    }

    private AtomicLong[] initPutMessageDistributeTime() {
        AtomicLong[] next = new AtomicLong[13];
        for (int i = 0; i < next.length; ++i) {
            next[i] = new AtomicLong(0L);
        }
        AtomicLong[] old = this.putMessageDistributeTime;
        this.putMessageDistributeTime = next;
        return old;
    }

    public long getPutMessageEntireTimeMax() {
        return this.putMessageEntireTimeMax;
    }

    public void setPutMessageEntireTimeMax(long value) {
        AtomicLong[] times = this.putMessageDistributeTime;
        if (null == times) {
            return;
        }
        if (value <= 0L) {
            times[0].incrementAndGet();
        } else if (value < 10L) {
            times[1].incrementAndGet();
        } else if (value < 50L) {
            times[2].incrementAndGet();
        } else if (value < 100L) {
            times[3].incrementAndGet();
        } else if (value < 200L) {
            times[4].incrementAndGet();
        } else if (value < 500L) {
            times[5].incrementAndGet();
        } else if (value < 1000L) {
            times[6].incrementAndGet();
        } else if (value < 2000L) {
            times[7].incrementAndGet();
        } else if (value < 3000L) {
            times[8].incrementAndGet();
        } else if (value < 4000L) {
            times[9].incrementAndGet();
        } else if (value < 5000L) {
            times[10].incrementAndGet();
        } else if (value < 10000L) {
            times[11].incrementAndGet();
        } else {
            times[12].incrementAndGet();
        }
        if (value > this.putMessageEntireTimeMax) {
            this.lockPut.lock();
            this.putMessageEntireTimeMax = value > this.putMessageEntireTimeMax ? value : this.putMessageEntireTimeMax;
            this.lockPut.unlock();
        }
    }

    public long getGetMessageEntireTimeMax() {
        return this.getMessageEntireTimeMax;
    }

    public void setGetMessageEntireTimeMax(long value) {
        if (value > this.getMessageEntireTimeMax) {
            this.lockGet.lock();
            this.getMessageEntireTimeMax = value > this.getMessageEntireTimeMax ? value : this.getMessageEntireTimeMax;
            this.lockGet.unlock();
        }
    }

    public long getDispatchMaxBuffer() {
        return this.dispatchMaxBuffer;
    }

    public void setDispatchMaxBuffer(long value) {
        this.dispatchMaxBuffer = value > this.dispatchMaxBuffer ? value : this.dispatchMaxBuffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        sb.append("\truntime: " + this.getFormatRuntime() + "\r\n");
        sb.append("\tputMessageEntireTimeMax: " + this.putMessageEntireTimeMax + "\r\n");
        sb.append("\tputMessageTimesTotal: " + totalTimes + "\r\n");
        sb.append("\tputMessageSizeTotal: " + this.getPutMessageSizeTotal() + "\r\n");
        sb.append("\tputMessageDistributeTime: " + this.getPutMessageDistributeTimeStringInfo(totalTimes) + "\r\n");
        sb.append("\tputMessageAverageSize: " + (double)this.getPutMessageSizeTotal() / totalTimes.doubleValue() + "\r\n");
        sb.append("\tdispatchMaxBuffer: " + this.dispatchMaxBuffer + "\r\n");
        sb.append("\tgetMessageEntireTimeMax: " + this.getMessageEntireTimeMax + "\r\n");
        sb.append("\tputTps: " + this.getPutTps() + "\r\n");
        sb.append("\tgetFoundTps: " + this.getGetFoundTps() + "\r\n");
        sb.append("\tgetMissTps: " + this.getGetMissTps() + "\r\n");
        sb.append("\tgetTotalTps: " + this.getGetTotalTps() + "\r\n");
        sb.append("\tgetTransferedTps: " + this.getGetTransferedTps() + "\r\n");
        return sb.toString();
    }

    public long getPutMessageTimesTotal() {
        long rs = 0L;
        for (AtomicLong data : this.putMessageTopicTimesTotal.values()) {
            rs += data.get();
        }
        return rs;
    }

    private String getFormatRuntime() {
        long millisecond = 1L;
        long second = 1000L;
        long minute = 60000L;
        long hour = 3600000L;
        long day = 86400000L;
        MessageFormat messageFormat = new MessageFormat("[ {0} days, {1} hours, {2} minutes, {3} seconds ]");
        long time = System.currentTimeMillis() - this.messageStoreBootTimestamp;
        long days = time / 86400000L;
        long hours = time % 86400000L / 3600000L;
        long minutes = time % 3600000L / 60000L;
        long seconds = time % 60000L / 1000L;
        return messageFormat.format(new Long[]{days, hours, minutes, seconds});
    }

    public long getPutMessageSizeTotal() {
        long rs = 0L;
        for (AtomicLong data : this.putMessageTopicSizeTotal.values()) {
            rs += data.get();
        }
        return rs;
    }

    private String getPutMessageDistributeTimeStringInfo(Long total) {
        return this.putMessageDistributeTimeToString();
    }

    private String getPutTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPutTps(10));
        sb.append(" ");
        sb.append(this.getPutTps(60));
        sb.append(" ");
        sb.append(this.getPutTps(600));
        return sb.toString();
    }

    private String getGetFoundTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetFoundTps(10));
        sb.append(" ");
        sb.append(this.getGetFoundTps(60));
        sb.append(" ");
        sb.append(this.getGetFoundTps(600));
        return sb.toString();
    }

    private String getGetMissTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetMissTps(10));
        sb.append(" ");
        sb.append(this.getGetMissTps(60));
        sb.append(" ");
        sb.append(this.getGetMissTps(600));
        return sb.toString();
    }

    private String getGetTotalTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTotalTps(10));
        sb.append(" ");
        sb.append(this.getGetTotalTps(60));
        sb.append(" ");
        sb.append(this.getGetTotalTps(600));
        return sb.toString();
    }

    private String getGetTransferedTps() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGetTransferedTps(10));
        sb.append(" ");
        sb.append(this.getGetTransferedTps(60));
        sb.append(" ");
        sb.append(this.getGetTransferedTps(600));
        return sb.toString();
    }

    private String putMessageDistributeTimeToString() {
        AtomicLong[] times = this.putMessageDistributeTime;
        if (null == times) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times.length; ++i) {
            long value = times[i].get();
            sb.append(String.format("%s:%d", PUT_MESSAGE_ENTIRE_TIME_MAX_DESC[i], value));
            sb.append(" ");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPutTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.putTimesList.getLast();
            if (this.putTimesList.size() > time) {
                CallSnapshot lastBefore = this.putTimesList.get(this.putTimesList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetFoundTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                CallSnapshot lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetMissTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                CallSnapshot lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTotalTps(int time) {
        this.lockSampling.lock();
        double found = 0.0;
        double miss = 0.0;
        try {
            CallSnapshot lastBefore;
            CallSnapshot last = this.getTimesFoundList.getLast();
            if (this.getTimesFoundList.size() > time) {
                lastBefore = this.getTimesFoundList.get(this.getTimesFoundList.size() - (time + 1));
                found = CallSnapshot.getTPS(lastBefore, last);
            }
            last = this.getTimesMissList.getLast();
            if (this.getTimesMissList.size() > time) {
                lastBefore = this.getTimesMissList.get(this.getTimesMissList.size() - (time + 1));
                miss = CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return Double.toString(found + miss);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGetTransferedTps(int time) {
        String result = "";
        this.lockSampling.lock();
        try {
            CallSnapshot last = this.transferedMsgCountList.getLast();
            if (this.transferedMsgCountList.size() > time) {
                CallSnapshot lastBefore = this.transferedMsgCountList.get(this.transferedMsgCountList.size() - (time + 1));
                result = result + CallSnapshot.getTPS(lastBefore, last);
            }
        }
        finally {
            this.lockSampling.unlock();
        }
        return result;
    }

    public HashMap<String, String> getRuntimeInfo() {
        HashMap<String, String> result = new HashMap<String, String>(64);
        Long totalTimes = this.getPutMessageTimesTotal();
        if (0L == totalTimes) {
            totalTimes = 1L;
        }
        result.put("bootTimestamp", String.valueOf(this.messageStoreBootTimestamp));
        result.put("runtime", this.getFormatRuntime());
        result.put("putMessageEntireTimeMax", String.valueOf(this.putMessageEntireTimeMax));
        result.put("putMessageTimesTotal", String.valueOf(totalTimes));
        result.put("putMessageSizeTotal", String.valueOf(this.getPutMessageSizeTotal()));
        result.put("putMessageDistributeTime", String.valueOf(this.getPutMessageDistributeTimeStringInfo(totalTimes)));
        result.put("putMessageAverageSize", String.valueOf((double)this.getPutMessageSizeTotal() / totalTimes.doubleValue()));
        result.put("dispatchMaxBuffer", String.valueOf(this.dispatchMaxBuffer));
        result.put("getMessageEntireTimeMax", String.valueOf(this.getMessageEntireTimeMax));
        result.put("putTps", String.valueOf(this.getPutTps()));
        result.put("getFoundTps", String.valueOf(this.getGetFoundTps()));
        result.put("getMissTps", String.valueOf(this.getGetMissTps()));
        result.put("getTotalTps", String.valueOf(this.getGetTotalTps()));
        result.put("getTransferedTps", String.valueOf(this.getGetTransferedTps()));
        return result;
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(1000L);
                this.sampling();
                this.printTps();
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    public String getServiceName() {
        return StoreStatsService.class.getSimpleName();
    }

    private void sampling() {
        this.lockSampling.lock();
        try {
            this.putTimesList.add(new CallSnapshot(System.currentTimeMillis(), this.getPutMessageTimesTotal()));
            if (this.putTimesList.size() > 601) {
                this.putTimesList.removeFirst();
            }
            this.getTimesFoundList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalFound.get()));
            if (this.getTimesFoundList.size() > 601) {
                this.getTimesFoundList.removeFirst();
            }
            this.getTimesMissList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTimesTotalMiss.get()));
            if (this.getTimesMissList.size() > 601) {
                this.getTimesMissList.removeFirst();
            }
            this.transferedMsgCountList.add(new CallSnapshot(System.currentTimeMillis(), this.getMessageTransferedMsgCount.get()));
            if (this.transferedMsgCountList.size() > 601) {
                this.transferedMsgCountList.removeFirst();
            }
        }
        finally {
            this.lockSampling.unlock();
        }
    }

    private void printTps() {
        if (System.currentTimeMillis() > this.lastPrintTimestamp + (long)(printTPSInterval * 1000)) {
            this.lastPrintTimestamp = System.currentTimeMillis();
            log.info("[STORETPS] put_tps {} get_found_tps {} get_miss_tps {} get_transfered_tps {}", new Object[]{this.getPutTps(printTPSInterval), this.getGetFoundTps(printTPSInterval), this.getGetMissTps(printTPSInterval), this.getGetTransferedTps(printTPSInterval)});
            AtomicLong[] times = this.initPutMessageDistributeTime();
            if (null == times) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            long totalPut = 0L;
            for (int i = 0; i < times.length; ++i) {
                long value = times[i].get();
                totalPut += value;
                sb.append(String.format("%s:%d", PUT_MESSAGE_ENTIRE_TIME_MAX_DESC[i], value));
                sb.append(" ");
            }
            log.info("[PAGECACHERT] TotalPut {}, PutMessageDistributeTime {}", (Object)totalPut, (Object)sb.toString());
        }
    }

    public AtomicLong getGetMessageTimesTotalFound() {
        return this.getMessageTimesTotalFound;
    }

    public AtomicLong getGetMessageTimesTotalMiss() {
        return this.getMessageTimesTotalMiss;
    }

    public AtomicLong getGetMessageTransferedMsgCount() {
        return this.getMessageTransferedMsgCount;
    }

    public AtomicLong getPutMessageFailedTimes() {
        return this.putMessageFailedTimes;
    }

    public AtomicLong getSinglePutMessageTopicSizeTotal(String topic) {
        AtomicLong rs = this.putMessageTopicSizeTotal.get(topic);
        if (null == rs) {
            rs = new AtomicLong(0L);
            this.putMessageTopicSizeTotal.put(topic, rs);
        }
        return rs;
    }

    public AtomicLong getSinglePutMessageTopicTimesTotal(String topic) {
        AtomicLong rs = this.putMessageTopicTimesTotal.get(topic);
        if (null == rs) {
            rs = new AtomicLong(0L);
            this.putMessageTopicTimesTotal.put(topic, rs);
        }
        return rs;
    }

    public Map<String, AtomicLong> getPutMessageTopicTimesTotal() {
        return this.putMessageTopicTimesTotal;
    }

    public Map<String, AtomicLong> getPutMessageTopicSizeTotal() {
        return this.putMessageTopicSizeTotal;
    }

    static class CallSnapshot {
        public final long timestamp;
        public final long callTimesTotal;

        public CallSnapshot(long timestamp, long callTimesTotal) {
            this.timestamp = timestamp;
            this.callTimesTotal = callTimesTotal;
        }

        public static double getTPS(CallSnapshot begin, CallSnapshot end) {
            long total = end.callTimesTotal - begin.callTimesTotal;
            Long time = end.timestamp - begin.timestamp;
            double tps = (double)total / time.doubleValue();
            return tps * 1000.0;
        }
    }
}

