/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.definition;

import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.protobuf.ProtobufMapper;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.utils.ScopedProtobufSchemaManager;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.OperationMeta;

public final class ProtobufManager {
    private static ProtobufManager instance = new ProtobufManager();
    private static ProtobufMapper mapper = new ProtobufMapper();
    private static ObjectWriter writer = mapper.writer();
    private static ObjectReader reader = mapper.reader();
    public static final String EXT_ID = "protobuf";
    private static final Object LOCK = new Object();
    private static ScopedProtobufSchemaManager defaultScopedProtobufSchemaManager = new ScopedProtobufSchemaManager(Thread.currentThread().getContextClassLoader());

    private ProtobufManager() {
    }

    public static ScopedProtobufSchemaManager getDefaultScopedProtobufSchemaManager() {
        return defaultScopedProtobufSchemaManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationProtobuf getOrCreateOperation(OperationMeta operationMeta) throws Exception {
        OperationProtobuf operationProtobuf = (OperationProtobuf)operationMeta.getExtData(EXT_ID);
        if (operationProtobuf == null) {
            Object object = LOCK;
            synchronized (object) {
                MicroserviceMeta microserviceMeta = operationMeta.getMicroserviceMeta();
                ScopedProtobufSchemaManager scopedProtobufSchemaManager = (ScopedProtobufSchemaManager)microserviceMeta.getExtData(EXT_ID);
                if (scopedProtobufSchemaManager == null) {
                    scopedProtobufSchemaManager = new ScopedProtobufSchemaManager(microserviceMeta.getClassLoader());
                    microserviceMeta.putExtData(EXT_ID, (Object)scopedProtobufSchemaManager);
                }
                if ((operationProtobuf = (OperationProtobuf)operationMeta.getExtData(EXT_ID)) == null) {
                    operationProtobuf = new OperationProtobuf(scopedProtobufSchemaManager, operationMeta);
                    operationMeta.putExtData(EXT_ID, (Object)operationProtobuf);
                }
            }
        }
        return operationProtobuf;
    }

    public static ProtobufManager getInstance() {
        return instance;
    }

    public static ProtobufMapper getMapper() {
        return mapper;
    }

    public static ObjectWriter getWriter() {
        return writer;
    }

    public static ObjectReader getReader() {
        return reader;
    }

    static {
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

