/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.codec.protobuf.utils;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.protostuff.runtime.RuntimeSchema;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.servicecomb.codec.protobuf.utils.ProtobufSchemaUtils;
import org.apache.servicecomb.codec.protobuf.utils.WrapClassConfig;
import org.apache.servicecomb.codec.protobuf.utils.WrapSchema;
import org.apache.servicecomb.codec.protobuf.utils.WrapType;
import org.apache.servicecomb.codec.protobuf.utils.schema.WrapSchemaFactory;
import org.apache.servicecomb.common.javassist.ClassConfig;
import org.apache.servicecomb.common.javassist.JavassistUtils;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;

public class ScopedProtobufSchemaManager {
    private ClassLoader classLoader;
    private Map<String, WrapSchema> schemaCache = new ConcurrentHashMapEx();

    public ScopedProtobufSchemaManager(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.classLoader = classLoader;
    }

    private WrapSchema createWrapSchema(WrapClassConfig config) {
        Class cls = JavassistUtils.createClass((ClassLoader)this.classLoader, (ClassConfig)config);
        RuntimeSchema schema = RuntimeSchema.createFrom((Class)cls);
        return WrapSchemaFactory.createSchema(schema, config.getType());
    }

    public WrapSchema getOrCreateSchema(Type type) {
        JavaType javaType = TypeFactory.defaultInstance().constructType(type);
        String key = javaType.toCanonical();
        return this.schemaCache.computeIfAbsent(key, k -> {
            if (!ProtobufSchemaUtils.isNeedWrap(javaType.getRawClass())) {
                RuntimeSchema schema = RuntimeSchema.createFrom((Class)javaType.getRawClass());
                return WrapSchemaFactory.createSchema(schema, WrapType.NOT_WRAP);
            }
            WrapClassConfig config = new WrapClassConfig();
            config.setType(WrapType.NORMAL_WRAP);
            config.setClassName("gen.wrap.protobuf." + ClassUtils.correctClassName((String)key));
            if (!Void.TYPE.isAssignableFrom(javaType.getRawClass())) {
                config.addField("field0", javaType);
            }
            JavassistUtils.genSingleWrapperInterface((ClassConfig)config);
            return this.createWrapSchema(config);
        });
    }

    public WrapSchema getOrCreateArgsSchema(OperationMeta operationMeta) {
        Method method = operationMeta.getMethod();
        String type = "gen." + method.getDeclaringClass().getName() + "." + method.getName() + ".Args";
        return this.schemaCache.computeIfAbsent(type, t -> {
            if (!ProtobufSchemaUtils.isArgsNeedWrap(method)) {
                Class<?> cls = method.getParameterTypes()[0];
                RuntimeSchema schema = RuntimeSchema.createFrom(cls);
                return WrapSchemaFactory.createSchema(schema, WrapType.ARGS_NOT_WRAP);
            }
            WrapClassConfig config = new WrapClassConfig();
            config.setType(WrapType.ARGS_WRAP);
            config.setClassName(type);
            Parameter[] params = method.getParameters();
            for (int idx = 0; idx < params.length; ++idx) {
                Parameter param = params[idx];
                String paramName = ClassUtils.correctMethodParameterName((String)operationMeta.getParamName(idx));
                config.addField(paramName, param.getParameterizedType());
            }
            JavassistUtils.genMultiWrapperInterface((ClassConfig)config);
            return this.createWrapSchema(config);
        });
    }
}

