/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.common;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public class ConfigConverter {
    private Map<String, Object> currentData = Collections.emptyMap();
    private Map<String, Object> lastRawData;
    private final List<String> fileSources;

    public ConfigConverter(List<String> fileSources) {
        this.fileSources = fileSources;
    }

    public Map<String, Object> getLastRawData() {
        return this.lastRawData;
    }

    public Map<String, Object> getCurrentData() {
        return this.currentData;
    }

    public Map<String, Object> updateData(Map<String, Object> rawData) {
        Map<String, Object> lastData = this.currentData;
        this.lastRawData = rawData;
        if (CollectionUtils.isEmpty(this.fileSources)) {
            this.currentData = rawData;
            return lastData;
        }
        HashMap<String, Object> fileProperties = new HashMap<String, Object>();
        this.fileSources.forEach(source -> {
            if (rawData.get(source) != null) {
                fileProperties.put((String)source, rawData.get(source));
            }
        });
        HashMap<String, Object> result = new HashMap<String, Object>(rawData.size());
        result.putAll(rawData);
        fileProperties.forEach((k, v) -> result.putAll(this.createFileSource(v)));
        this.currentData = result;
        return lastData;
    }

    private Map<String, Object> createFileSource(Object v) {
        YamlPropertiesFactoryBean yamlFactory = new YamlPropertiesFactoryBean();
        yamlFactory.setResources(new Resource[]{new ByteArrayResource(v.toString().getBytes(Charset.forName("UTF-8")))});
        return this.propertiesToMap(yamlFactory.getObject());
    }

    private Map<String, Object> propertiesToMap(Properties properties) {
        if (properties == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            result.put(key, value);
        }
        return result;
    }
}

