/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shenyu.common.utils.VersionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfiguration {
    private static final String DEFAULT_SWAGGER_API_VERSION = "2.3.0";
    private static final String TITLE = "ShenYu Admin API Document";
    private static final String DESCRIPTION = "ShenYu Admin API";
    private static final String CONTACT_NAME = "ShenYu";
    private static final String CONTACT_URL = "https://github.com/apache/shenyu";
    private static final String CONTACT_EMAIL = "dev@shenyu.apache.org";
    private static final String TOKEN_DESCRIPTION = "user auth";
    private static final String TOKEN_MODEL_REF_TYPE = "string";
    private static final String TOKEN_PARAMETER_TYPE = "header";
    @Value(value="${shenyu.swagger.enable:false}")
    private boolean enable;

    @Bean
    public Docket createRestApi() {
        ParameterBuilder commonParam = new ParameterBuilder();
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        commonParam.name("X-Access-Token").description(TOKEN_DESCRIPTION).modelRef((ModelReference)new ModelRef(TOKEN_MODEL_REF_TYPE)).parameterType(TOKEN_PARAMETER_TYPE).required(false);
        pars.add(commonParam.build());
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.enable).globalOperationParameters(pars).select().apis(RequestHandlerSelectors.basePackage((String)"org.apache.shenyu.admin.controller")).paths(PathSelectors.any()).build();
    }

    @Bean
    public BeanPostProcessor springfoxBeanHandler() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcRequestHandlerProvider) {
                    this.customizeSpringfoxHandlerMappings(this.getHandlerMappings(bean));
                }
                return bean;
            }

            private <T extends RequestMappingInfoHandlerMapping> void customizeSpringfoxHandlerMappings(List<T> mappings) {
                List copy = mappings.stream().filter(mapping -> mapping.getPatternParser() == null).collect(Collectors.toList());
                mappings.clear();
                mappings.addAll(copy);
            }

            private List<RequestMappingInfoHandlerMapping> getHandlerMappings(Object bean) {
                try {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    field.setAccessible(true);
                    return (List)field.get(bean);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(TITLE).description(DESCRIPTION).version(VersionUtils.getVersion(this.getClass(), (String)DEFAULT_SWAGGER_API_VERSION)).contact(new Contact(CONTACT_NAME, CONTACT_URL, CONTACT_EMAIL)).build();
    }
}

