/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.dto.DashboardUserModifyPasswordDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.DashboardUserQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.DashboardUserEditVO;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.common.utils.DigestUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"/dashboardUser"})
public class DashboardUserController {
    private final DashboardUserService dashboardUserService;

    public DashboardUserController(DashboardUserService dashboardUserService) {
        this.dashboardUserService = dashboardUserService;
    }

    @GetMapping(value={""})
    @RequiresPermissions(value={"system:manager:list"})
    public ShenyuAdminResult queryDashboardUsers(String userName, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        CommonPager<DashboardUserVO> commonPager = this.dashboardUserService.listByPage(new DashboardUserQuery(userName, new PageParameter(currentPage, pageSize)));
        if (CollectionUtils.isNotEmpty(commonPager.getDataList())) {
            return ShenyuAdminResult.success("query success", commonPager);
        }
        return ShenyuAdminResult.error("user info is empty");
    }

    @GetMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:manager:list"})
    public ShenyuAdminResult detailDashboardUser(@PathVariable(value="id") String id) {
        DashboardUserEditVO dashboardUserEditVO = this.dashboardUserService.findById(id);
        return Optional.ofNullable(dashboardUserEditVO).map(item -> ShenyuAdminResult.success("detail success", item)).orElseGet(() -> ShenyuAdminResult.error("user info is empty"));
    }

    @PostMapping(value={""})
    @RequiresPermissions(value={"system:manager:add"})
    public ShenyuAdminResult createDashboardUser(@Valid @RequestBody DashboardUserDTO dashboardUserDTO) {
        return Optional.ofNullable(dashboardUserDTO).map(item -> {
            item.setPassword(DigestUtils.sha512Hex((String)item.getPassword()));
            Integer createCount = this.dashboardUserService.createOrUpdate((DashboardUserDTO)item);
            return ShenyuAdminResult.success("create success", createCount);
        }).orElseGet(() -> ShenyuAdminResult.error("empty user info, please confirm"));
    }

    @PutMapping(value={"/{id}"})
    @RequiresPermissions(value={"system:manager:edit"})
    public ShenyuAdminResult updateDashboardUser(@PathVariable(value="id") @Existed(provider=DashboardUserMapper.class, message="user is not found") @Existed(provider=DashboardUserMapper.class, message="user is not found") String id, @Valid @RequestBody DashboardUserDTO dashboardUserDTO) {
        dashboardUserDTO.setId(id);
        if (StringUtils.isNotBlank((CharSequence)dashboardUserDTO.getPassword())) {
            dashboardUserDTO.setPassword(DigestUtils.sha512Hex((String)dashboardUserDTO.getPassword()));
        }
        Integer updateCount = this.dashboardUserService.createOrUpdate(dashboardUserDTO);
        return ShenyuAdminResult.success("update success", updateCount);
    }

    @PutMapping(value={"/modify-password/{id}"})
    @RequiresPermissions(value={"system:manager:edit"})
    public ShenyuAdminResult modifyPassword(@PathVariable(value="id") @Existed(provider=DashboardUserMapper.class, message="user is not found") @Existed(provider=DashboardUserMapper.class, message="user is not found") String id, @Valid @RequestBody DashboardUserModifyPasswordDTO dashboardUserModifyPasswordDTO) {
        UserInfo userInfo = (UserInfo)SecurityUtils.getSubject().getPrincipal();
        if (Objects.isNull(userInfo)) {
            return ShenyuAdminResult.error("user not login please login first");
        }
        dashboardUserModifyPasswordDTO.setId(id);
        if (!userInfo.getUserId().equals(id) && !userInfo.getUserName().equals(dashboardUserModifyPasswordDTO.getUserName())) {
            return ShenyuAdminResult.error("can not modify other user password");
        }
        dashboardUserModifyPasswordDTO.setPassword(DigestUtils.sha512Hex((String)dashboardUserModifyPasswordDTO.getPassword()));
        return ShenyuAdminResult.success("update success", this.dashboardUserService.modifyPassword(dashboardUserModifyPasswordDTO));
    }

    @DeleteMapping(value={"/batch"})
    @RequiresPermissions(value={"system:manager:delete"})
    public ShenyuAdminResult deleteDashboardUser(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Assert.isTrue(SessionUtil.isAdmin(), "This function can only be used by the admin(root) user");
        return ShenyuAdminResult.success("delete success", this.dashboardUserService.delete(new HashSet<String>(ids)));
    }
}

