/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Optional;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.PermissionMenuVO;
import org.apache.shenyu.admin.service.PermissionService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/permission"})
public class PermissionController {
    private final PermissionService permissionService;

    public PermissionController(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    @GetMapping(value={"/getUserPermissionByToken"})
    public ShenyuAdminResult getUserPermissionByToken(@RequestParam(name="token") String token) {
        PermissionMenuVO permissionMenuVO = this.permissionService.getPermissionMenu(token);
        return Optional.ofNullable(permissionMenuVO).map(item -> ShenyuAdminResult.success("get menu and permission success", item)).orElseGet(() -> ShenyuAdminResult.error("get menu and permission failed"));
    }
}

