/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterPublisher;
import org.apache.shenyu.register.client.server.api.ShenyuClientServerRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.apache.shenyu.spi.Join;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/shenyu-client"})
@Join
public class ShenyuClientHttpRegistryController
implements ShenyuClientServerRegisterRepository {
    private ShenyuClientServerRegisterPublisher publisher;

    public void init(ShenyuClientServerRegisterPublisher publisher, ShenyuRegisterCenterConfig config) {
        this.publisher = publisher;
    }

    public void close() {
        this.publisher.close();
    }

    @PostMapping(value={"/register-metadata"})
    @ResponseBody
    public String registerMetadata(@RequestBody MetaDataRegisterDTO metaDataRegisterDTO) {
        this.publisher.publish((DataTypeParent)metaDataRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-uri"})
    @ResponseBody
    public String registerURI(@RequestBody URIRegisterDTO uriRegisterDTO) {
        this.publisher.publish((DataTypeParent)uriRegisterDTO);
        return "success";
    }

    @PostMapping(value={"/register-apiDoc"})
    @ResponseBody
    public String registerApiDoc(@RequestBody ApiDocRegisterDTO apiDocRegisterDTO) {
        this.publisher.publish((DataTypeParent)apiDocRegisterDTO);
        return "success";
    }
}

