/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.ConfigDataCache;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.ConfigData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDataChangedListener
implements DataChangedListener,
InitializingBean {
    protected static final ConcurrentMap<String, ConfigDataCache> CACHE = new ConcurrentHashMap<String, ConfigDataCache>();
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDataChangedListener.class);
    @Resource
    private AppAuthService appAuthService;
    @Resource
    private PluginService pluginService;
    @Resource
    private RuleService ruleService;
    @Resource
    private SelectorService selectorService;
    @Resource
    private MetaDataService metaDataService;

    public ConfigData<?> fetchConfig(ConfigGroupEnum groupKey) {
        ConfigDataCache config = (ConfigDataCache)CACHE.get(groupKey.name());
        switch (groupKey) {
            case APP_AUTH: {
                return this.buildConfigData(config, AppAuthData.class);
            }
            case PLUGIN: {
                return this.buildConfigData(config, PluginData.class);
            }
            case RULE: {
                return this.buildConfigData(config, RuleData.class);
            }
            case SELECTOR: {
                return this.buildConfigData(config, SelectorData.class);
            }
            case META_DATA: {
                return this.buildConfigData(config, MetaData.class);
            }
        }
        throw new IllegalStateException("Unexpected groupKey: " + groupKey);
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        this.updateAppAuthCache();
        this.afterAppAuthChanged(changed, eventType);
    }

    protected void afterAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        this.updateMetaDataCache();
        this.afterMetaDataChanged(changed, eventType);
    }

    protected void afterMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        this.updatePluginCache();
        this.afterPluginChanged(changed, eventType);
    }

    protected void afterPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        this.updateRuleCache();
        this.afterRuleChanged(changed, eventType);
    }

    protected void afterRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        if (CollectionUtils.isEmpty(changed)) {
            return;
        }
        this.updateSelectorCache();
        this.afterSelectorChanged(changed, eventType);
    }

    protected void afterSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
    }

    public final void afterPropertiesSet() {
        this.refreshLocalCache();
        this.afterInitialize();
    }

    protected abstract void afterInitialize();

    protected <T> void updateCache(ConfigGroupEnum group, List<T> data) {
        String json = GsonUtils.getInstance().toJson(data);
        ConfigDataCache newVal = new ConfigDataCache(group.name(), json, DigestUtils.md5Hex((String)json), System.currentTimeMillis());
        ConfigDataCache oldVal = CACHE.put(newVal.getGroup(), newVal);
        LOG.info("update config cache[{}], old: {}, updated: {}", new Object[]{group, oldVal, newVal});
    }

    protected void refreshLocalCache() {
        this.updateAppAuthCache();
        this.updatePluginCache();
        this.updateRuleCache();
        this.updateSelectorCache();
        this.updateMetaDataCache();
    }

    protected void updateSelectorCache() {
        this.updateCache(ConfigGroupEnum.SELECTOR, this.selectorService.listAll());
    }

    protected void updateRuleCache() {
        this.updateCache(ConfigGroupEnum.RULE, this.ruleService.listAll());
    }

    protected void updatePluginCache() {
        this.updateCache(ConfigGroupEnum.PLUGIN, this.pluginService.listAll());
    }

    protected void updateAppAuthCache() {
        this.updateCache(ConfigGroupEnum.APP_AUTH, this.appAuthService.listAll());
    }

    protected void updateMetaDataCache() {
        this.updateCache(ConfigGroupEnum.META_DATA, this.metaDataService.listAll());
    }

    private <T> ConfigData<T> buildConfigData(ConfigDataCache config, Class<T> dataType) {
        return new ConfigData(config.getMd5(), config.getLastModifyTime(), GsonUtils.getInstance().fromList(config.getJson(), dataType));
    }
}

