/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListDataChangedListener
implements DataChangedListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractListDataChangedListener.class);
    private static final ConcurrentMap<String, PluginData> PLUGIN_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<SelectorData>> SELECTOR_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, List<RuleData>> RULE_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, AppAuthData> AUTH_MAP = Maps.newConcurrentMap();
    private static final ConcurrentMap<String, MetaData> META_DATA = Maps.newConcurrentMap();
    private static final Comparator<SelectorData> SELECTOR_DATA_COMPARATOR = Comparator.comparing(SelectorData::getSort);
    private static final Comparator<RuleData> RULE_DATA_COMPARATOR = Comparator.comparing(RuleData::getSort);
    private final ChangeData changeData;

    public AbstractListDataChangedListener(ChangeData changeData) {
        this.changeData = changeData;
    }

    @Override
    public void onAppAuthChanged(List<AppAuthData> changed, DataEventTypeEnum eventType) {
        this.updateAuthMap(this.getConfig(this.changeData.getAuthDataId()));
        switch (eventType) {
            case DELETE: {
                changed.forEach(appAuth -> AUTH_MAP.remove(appAuth.getAppKey()));
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(AUTH_MAP.keySet());
                changed.forEach(appAuth -> {
                    set.remove(appAuth.getAppKey());
                    AUTH_MAP.put(appAuth.getAppKey(), (AppAuthData)appAuth);
                });
                AUTH_MAP.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(appAuth -> AUTH_MAP.put(appAuth.getAppKey(), (AppAuthData)appAuth));
            }
        }
        this.publishConfig(this.changeData.getAuthDataId(), AUTH_MAP);
        LOG.debug("[DataChangedListener] AppAuthChanged {}", (Object)this.changeData.getAuthDataId());
    }

    @Override
    public void onPluginChanged(List<PluginData> changed, DataEventTypeEnum eventType) {
        this.updatePluginMap(this.getConfig(this.changeData.getPluginDataId()));
        switch (eventType) {
            case DELETE: {
                changed.forEach(plugin -> PLUGIN_MAP.remove(plugin.getName()));
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(PLUGIN_MAP.keySet());
                changed.forEach(plugin -> {
                    set.remove(plugin.getName());
                    PLUGIN_MAP.put(plugin.getName(), (PluginData)plugin);
                });
                PLUGIN_MAP.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(plugin -> PLUGIN_MAP.put(plugin.getName(), (PluginData)plugin));
            }
        }
        this.publishConfig(this.changeData.getPluginDataId(), PLUGIN_MAP);
        LOG.debug("[DataChangedListener] PluginChanged {}", (Object)this.changeData.getPluginDataId());
    }

    @Override
    public void onSelectorChanged(List<SelectorData> changed, DataEventTypeEnum eventType) {
        this.updateSelectorMap(this.getConfig(this.changeData.getSelectorDataId()));
        switch (eventType) {
            case DELETE: {
                changed.forEach(selector -> {
                    List ls = ((List)SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList())).stream().filter(s -> !s.getId().equals(selector.getId())).sorted(SELECTOR_DATA_COMPARATOR).collect(Collectors.toList());
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                if (CollectionUtils.isNotEmpty(changed)) {
                    SELECTOR_MAP.remove(changed.get(0).getPluginName());
                }
                changed.forEach(selector -> {
                    ArrayList<SelectorData> ls = new ArrayList<SelectorData>(SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList()));
                    ls.add((SelectorData)selector);
                    ls.sort(SELECTOR_DATA_COMPARATOR);
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
                break;
            }
            default: {
                changed.forEach(selector -> {
                    List ls = ((List)SELECTOR_MAP.getOrDefault(selector.getPluginName(), new ArrayList())).stream().filter(s -> !s.getId().equals(selector.getId())).collect(Collectors.toList());
                    ls.add(selector);
                    ls.sort(SELECTOR_DATA_COMPARATOR);
                    SELECTOR_MAP.put(selector.getPluginName(), ls);
                });
            }
        }
        this.publishConfig(this.changeData.getSelectorDataId(), SELECTOR_MAP);
        LOG.debug("[DataChangedListener] SelectorChanged {}", (Object)this.changeData.getSelectorDataId());
    }

    @Override
    public void onMetaDataChanged(List<MetaData> changed, DataEventTypeEnum eventType) {
        this.updateMetaDataMap(this.getConfig(this.changeData.getMetaDataId()));
        switch (eventType) {
            case DELETE: {
                changed.forEach(meta -> META_DATA.remove(meta.getPath()));
                break;
            }
            case REFRESH: 
            case MYSELF: {
                HashSet set = new HashSet(META_DATA.keySet());
                changed.forEach(meta -> {
                    set.remove(meta.getPath());
                    META_DATA.put(meta.getPath(), (MetaData)meta);
                });
                META_DATA.keySet().removeAll(set);
                break;
            }
            default: {
                changed.forEach(meta -> {
                    META_DATA.values().stream().filter(md -> Objects.equals(md.getId(), meta.getId())).forEach(md -> META_DATA.remove(md.getPath()));
                    META_DATA.put(meta.getPath(), (MetaData)meta);
                });
            }
        }
        this.publishConfig(this.changeData.getMetaDataId(), META_DATA);
        LOG.debug("[DataChangedListener] MetaDataChanged {}", (Object)this.changeData.getMetaDataId());
    }

    @Override
    public void onRuleChanged(List<RuleData> changed, DataEventTypeEnum eventType) {
        this.updateRuleMap(this.getConfig(this.changeData.getRuleDataId()));
        switch (eventType) {
            case DELETE: {
                changed.forEach(rule -> {
                    List ls = ((List)RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList())).stream().filter(s -> !s.getId().equals(rule.getId())).sorted(RULE_DATA_COMPARATOR).collect(Collectors.toList());
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
                break;
            }
            case REFRESH: 
            case MYSELF: {
                Set selectIdSet = changed.stream().map(RuleData::getSelectorId).collect(Collectors.toSet());
                RULE_MAP.keySet().removeAll(selectIdSet);
                changed.forEach(rule -> {
                    ArrayList<RuleData> ls = new ArrayList<RuleData>(RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList()));
                    ls.add((RuleData)rule);
                    ls.sort(RULE_DATA_COMPARATOR);
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
                break;
            }
            default: {
                changed.forEach(rule -> {
                    List ls = ((List)RULE_MAP.getOrDefault(rule.getSelectorId(), new ArrayList())).stream().filter(s -> !s.getId().equals(rule.getId())).collect(Collectors.toList());
                    ls.add(rule);
                    ls.sort(RULE_DATA_COMPARATOR);
                    RULE_MAP.put(rule.getSelectorId(), ls);
                });
            }
        }
        this.publishConfig(this.changeData.getRuleDataId(), RULE_MAP);
        LOG.debug("[DataChangedListener] RuleChanged {}", (Object)this.changeData.getRuleDataId());
    }

    private void updateAuthMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(AUTH_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            AUTH_MAP.put((String)e.getKey(), (AppAuthData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), AppAuthData.class));
        }
        AUTH_MAP.keySet().removeAll(set);
    }

    private void updatePluginMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(PLUGIN_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            PLUGIN_MAP.put((String)e.getKey(), (PluginData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), PluginData.class));
        }
        PLUGIN_MAP.keySet().removeAll(set);
    }

    private void updateSelectorMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(SELECTOR_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            ArrayList ls = new ArrayList();
            ((JsonElement)e.getValue()).getAsJsonArray().forEach(je -> ls.add((SelectorData)GsonUtils.getInstance().fromJson(je, SelectorData.class)));
            SELECTOR_MAP.put((String)e.getKey(), ls);
        }
        SELECTOR_MAP.keySet().removeAll(set);
    }

    private void updateMetaDataMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(META_DATA.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            META_DATA.put((String)e.getKey(), (MetaData)GsonUtils.getInstance().fromJson((JsonElement)e.getValue(), MetaData.class));
        }
        META_DATA.keySet().removeAll(set);
    }

    private void updateRuleMap(String configInfo) {
        JsonObject jo = (JsonObject)GsonUtils.getInstance().fromJson(configInfo, JsonObject.class);
        HashSet set = new HashSet(RULE_MAP.keySet());
        for (Map.Entry e : jo.entrySet()) {
            set.remove(e.getKey());
            ArrayList ls = new ArrayList();
            ((JsonElement)e.getValue()).getAsJsonArray().forEach(je -> ls.add((RuleData)GsonUtils.getInstance().fromJson(je, RuleData.class)));
            RULE_MAP.put((String)e.getKey(), ls);
        }
        RULE_MAP.keySet().removeAll(set);
    }

    public abstract void publishConfig(String var1, Object var2);

    public abstract String getConfig(String var1);

    public static class ChangeData {
        private final String pluginDataId;
        private final String selectorDataId;
        private final String ruleDataId;
        private final String authDataId;
        private final String metaDataId;

        public ChangeData(String pluginDataId, String selectorDataId, String ruleDataId, String authDataId, String metaDataId) {
            this.pluginDataId = pluginDataId;
            this.selectorDataId = selectorDataId;
            this.ruleDataId = ruleDataId;
            this.authDataId = authDataId;
            this.metaDataId = metaDataId;
        }

        public String getPluginDataId() {
            return this.pluginDataId;
        }

        public String getSelectorDataId() {
            return this.selectorDataId;
        }

        public String getRuleDataId() {
            return this.ruleDataId;
        }

        public String getAuthDataId() {
            return this.authDataId;
        }

        public String getMetaDataId() {
            return this.metaDataId;
        }
    }
}

