/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Objects;
import org.apache.shenyu.admin.listener.AbstractListDataChangedListener;
import org.apache.shenyu.common.utils.GsonUtils;

public class ConsulDataChangedListener
extends AbstractListDataChangedListener {
    private final ConsulClient consulClient;

    public ConsulDataChangedListener(ConsulClient consulClient) {
        super(new AbstractListDataChangedListener.ChangeData("shenyu/sync/plugin", "shenyu/sync/selector", "shenyu/sync/rule", "shenyu/sync/auth", "shenyu/sync/meta"));
        this.consulClient = consulClient;
    }

    @Override
    public void publishConfig(String dataKey, Object data) {
        this.consulClient.setKVValue(dataKey, GsonUtils.getInstance().toJson(data));
    }

    @Override
    public String getConfig(String dataKey) {
        Response kvValue = this.consulClient.getKVValue(dataKey);
        return Objects.nonNull(kvValue.getValue()) ? ((GetValue)kvValue.getValue()).getDecodedValue() : "{}";
    }
}

