/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.zookeeper;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.selector.DivideUpstream;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperClient;
import org.apache.shenyu.register.client.server.zookeeper.ZookeeperConfig;
import org.apache.zookeeper.CreateMode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class HttpServiceDiscovery
implements InitializingBean {
    public static final String ROOT = "/shenyu/register";
    public static final String URI_PATH = "/shenyu/register/*/*";
    private ZookeeperClient zkClient;
    private final SelectorService selectorService;
    private final SelectorMapper selectorMapper;
    private final ApplicationEventPublisher eventPublisher;
    private final Environment env;
    private volatile List<String> contextPathList;

    @Autowired(required=false)
    public HttpServiceDiscovery(SelectorService selectorService, SelectorMapper selectorMapper, ApplicationEventPublisher eventPublisher, Environment env) {
        this.selectorService = selectorService;
        this.selectorMapper = selectorMapper;
        this.eventPublisher = eventPublisher;
        this.env = env;
    }

    public void afterPropertiesSet() {
        Boolean register = (Boolean)this.env.getProperty("shenyu.http.register", Boolean.class, (Object)false);
        if (!register.booleanValue()) {
            return;
        }
        String zookeeperUrl = this.env.getProperty("shenyu.http.zookeeperUrl", "");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{zookeeperUrl})) {
            this.zkClient = this.createZkClient(zookeeperUrl);
            boolean exists = this.zkClient.isExist(ROOT);
            if (!exists) {
                this.zkClient.createOrUpdate(ROOT, "", CreateMode.PERSISTENT);
            }
            this.zkClient.addCache(ROOT, new TreeCacheListener[]{new HttpServiceListener()});
        }
    }

    @VisibleForTesting
    ZookeeperClient createZkClient(String zookeeperUrl) {
        ZookeeperConfig config = new ZookeeperConfig(zookeeperUrl);
        config.setSessionTimeoutMilliseconds(5000).setConnectionTimeoutMilliseconds(2000);
        ZookeeperClient client = new ZookeeperClient(config);
        client.start();
        return client;
    }

    private void updateServiceList(List<String> children, String contextPath) {
        ArrayList<String> uriList = new ArrayList<String>();
        for (String subNode : children) {
            String data = this.zkClient.get(subNode);
            uriList.add(data);
        }
        this.updateSelectorHandler(contextPath, uriList);
    }

    private void updateSelectorHandler(String contextPath, List<String> uriList) {
        SelectorDO selector = this.selectorService.findByName(contextPath);
        if (Objects.nonNull(selector)) {
            SelectorData selectorData = this.selectorService.buildByName(contextPath);
            if (uriList == null) {
                selector.setHandle("");
                selectorData.setHandle("");
            } else {
                String handler = GsonUtils.getInstance().toJson(this.buildDivideUpstream(uriList));
                selector.setHandle(handler);
                selectorData.setHandle(handler);
            }
            this.selectorMapper.updateSelective(selector);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.UPDATE, Collections.singletonList(selectorData)));
        }
    }

    private List<DivideUpstream> buildDivideUpstream(List<String> uriList) {
        return uriList.stream().map(uri -> {
            DivideUpstream divideUpstream = DivideUpstream.builder().upstreamHost("localhost").protocol("http://").upstreamUrl(uri).weight(50).build();
            return divideUpstream;
        }).collect(Collectors.toList());
    }

    class HttpServiceListener
    implements TreeCacheListener {
        HttpServiceListener() {
        }

        public void childEvent(CuratorFramework client, TreeCacheEvent event) throws Exception {
            String path = event.getData().getPath();
            if (!path.contains(HttpServiceDiscovery.ROOT)) {
                return;
            }
            int lastSepIndex = path.lastIndexOf("/");
            String contextPath = path.substring(0, lastSepIndex);
            List childrenList = HttpServiceDiscovery.this.zkClient.getChildren(contextPath);
            List collect = childrenList.stream().map(r -> contextPath + "/" + r).collect(Collectors.toList());
            HttpServiceDiscovery.this.updateServiceList(collect, contextPath);
        }
    }
}

