/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.dto;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.SelectorConditionDTO;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.hibernate.validator.constraints.Range;

public final class SelectorDTO
implements Serializable {
    private static final long serialVersionUID = -4979839188302702999L;
    @Existed(provider=SelectorMapper.class, nullOfIgnore=true, message="selector is not existed")
    private @Existed(provider=SelectorMapper.class, nullOfIgnore=true, message="selector is not existed") String id;
    @NotBlank
    @Existed(provider=PluginMapper.class, message="plugin is not existed")
    private @NotBlank @Existed(provider=PluginMapper.class, message="plugin is not existed") String pluginId;
    @NotBlank
    private String name;
    private Integer matchMode;
    @NotNull
    @Min(value=0L)
    @Max(value=1L)
    private @NotNull @Min(value=0L) @Max(value=1L) Integer type;
    @NotNull
    @Range(min=1L, max=1000L)
    private @NotNull @Range(min=1L, max=1000L) Integer sort;
    @NotNull
    private Boolean enabled;
    @NotNull
    private Boolean loged;
    @NotNull
    private Boolean continued;
    private String handle;
    private List<SelectorConditionDTO> selectorConditions;

    public SelectorDTO() {
    }

    public SelectorDTO(String id, @NotBlank String pluginId, @NotBlank String name, Integer matchMode, @NotNull Integer type, @NotNull Integer sort, @NotNull Boolean enabled, Boolean loged, @NotNull Boolean continued, String handle, @Valid List<SelectorConditionDTO> selectorConditions) {
        this.id = id;
        this.pluginId = pluginId;
        this.name = name;
        this.matchMode = matchMode;
        this.type = type;
        this.sort = sort;
        this.enabled = enabled;
        this.loged = loged;
        this.continued = continued;
        this.handle = handle;
        this.selectorConditions = selectorConditions;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public void setLoged(Boolean loged) {
        this.loged = loged;
    }

    public Boolean getContinued() {
        return this.continued;
    }

    public void setContinued(Boolean continued) {
        this.continued = continued;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public List<SelectorConditionDTO> getSelectorConditions() {
        return this.selectorConditions;
    }

    public void setSelectorConditions(List<SelectorConditionDTO> selectorConditions) {
        this.selectorConditions = selectorConditions;
    }

    public static SelectorDTOBuilder builder() {
        return new SelectorDTOBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorDTO)) {
            return false;
        }
        SelectorDTO that = (SelectorDTO)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.name, that.name) && Objects.equals(this.matchMode, that.matchMode) && Objects.equals(this.type, that.type) && Objects.equals(this.sort, that.sort) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.loged, that.loged) && Objects.equals(this.continued, that.continued) && Objects.equals(this.handle, that.handle) && Objects.equals(this.selectorConditions, that.selectorConditions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pluginId, this.name, this.matchMode, this.type, this.sort, this.enabled, this.loged, this.continued, this.handle, this.selectorConditions);
    }

    public static final class SelectorDTOBuilder {
        private String id;
        private String pluginId;
        private String name;
        private Integer matchMode;
        private Integer type;
        private Integer sort;
        private Boolean enabled;
        private Boolean loged;
        private Boolean continued;
        private String handle;
        private List<SelectorConditionDTO> selectorConditions;

        private SelectorDTOBuilder() {
        }

        public SelectorDTOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SelectorDTOBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public SelectorDTOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SelectorDTOBuilder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public SelectorDTOBuilder type(Integer type) {
            this.type = type;
            return this;
        }

        public SelectorDTOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public SelectorDTOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public SelectorDTOBuilder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public SelectorDTOBuilder continued(Boolean continued) {
            this.continued = continued;
            return this;
        }

        public SelectorDTOBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public SelectorDTOBuilder selectorConditions(List<SelectorConditionDTO> selectorConditions) {
            this.selectorConditions = selectorConditions;
            return this;
        }

        public SelectorDTO build() {
            return new SelectorDTO(this.id, this.pluginId, this.name, this.matchMode, this.type, this.sort, this.enabled, this.loged, this.continued, this.handle, this.selectorConditions);
        }
    }
}

