/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.dto.CreateResourceDTO;
import org.apache.shenyu.admin.model.dto.ResourceDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;
import reactor.util.StringUtils;

public final class ResourceDO
extends BaseDO {
    private static final long serialVersionUID = 4663697054300237200L;
    private String parentId;
    private String title;
    private String name;
    private String url;
    private String component;
    private Integer resourceType;
    private Integer sort;
    private String icon;
    private Boolean isLeaf;
    private Integer isRoute;
    private String perms;
    private Integer status;

    public ResourceDO() {
    }

    public ResourceDO(String parentId, String title, String name, String url, String component, Integer resourceType, Integer sort, String icon, Boolean isLeaf, Integer isRoute, String perms, Integer status) {
        this.parentId = parentId;
        this.title = title;
        this.name = name;
        this.url = url;
        this.component = component;
        this.resourceType = resourceType;
        this.sort = sort;
        this.icon = icon;
        this.isLeaf = isLeaf;
        this.isRoute = isRoute;
        this.perms = perms;
        this.status = status;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Integer getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Integer resourceType) {
        this.resourceType = resourceType;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public Boolean getIsLeaf() {
        return this.isLeaf;
    }

    public void setIsLeaf(Boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public Integer getIsRoute() {
        return this.isRoute;
    }

    public void setIsRoute(Integer isRoute) {
        this.isRoute = isRoute;
    }

    public String getPerms() {
        return this.perms;
    }

    public void setPerms(String perms) {
        this.perms = perms;
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public static ResourceDOBuilder builder() {
        return new ResourceDOBuilder();
    }

    public static ResourceDO buildResourceDO(ResourceDTO resourceDTO) {
        return Optional.ofNullable(resourceDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ResourceDO resourceDO = ResourceDO.builder().parentId(item.getParentId()).title(item.getTitle()).name(item.getName()).url(item.getUrl()).component(item.getComponent()).resourceType(item.getResourceType()).sort(item.getSort()).icon(item.getIcon()).isLeaf(item.getIsLeaf()).isRoute(item.getIsRoute()).perms(item.getPerms()).status(item.getStatus()).build();
            if (StringUtils.isEmpty((Object)item.getId())) {
                resourceDO.setId(UUIDUtils.getInstance().generateShortUuid());
                resourceDO.setDateCreated(currentTime);
            } else {
                resourceDO.setId(item.getId());
            }
            return resourceDO;
        }).orElse(null);
    }

    public static ResourceDO buildResourceDO(CreateResourceDTO createResourceDTO) {
        return Optional.ofNullable(createResourceDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            ResourceDO resourceDO = ResourceDO.builder().parentId(item.getParentId()).title(item.getTitle()).name(item.getName()).url(item.getUrl()).component(item.getComponent()).resourceType(item.getResourceType()).sort(item.getSort()).icon(item.getIcon()).isLeaf(item.getIsLeaf()).isRoute(item.getIsRoute()).perms(item.getPerms()).status(item.getStatus()).id(UUIDUtils.getInstance().generateShortUuid()).dateCreated(currentTime).build();
            return resourceDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceDO that = (ResourceDO)o;
        return Objects.equals(this.parentId, that.parentId) && Objects.equals(this.title, that.title) && Objects.equals(this.name, that.name) && Objects.equals(this.url, that.url) && Objects.equals(this.component, that.component) && Objects.equals(this.resourceType, that.resourceType) && Objects.equals(this.sort, that.sort) && Objects.equals(this.icon, that.icon) && Objects.equals(this.isLeaf, that.isLeaf) && Objects.equals(this.isRoute, that.isRoute) && Objects.equals(this.perms, that.perms) && Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parentId, this.title, this.name, this.url, this.component, this.resourceType, this.sort, this.icon, this.isLeaf, this.isRoute, this.perms, this.status);
    }

    public static final class ResourceDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String parentId;
        private String title;
        private String name;
        private String url;
        private String component;
        private Integer resourceType;
        private Integer sort;
        private String icon;
        private Boolean isLeaf;
        private Integer isRoute;
        private String perms;
        private Integer status;

        private ResourceDOBuilder() {
        }

        public ResourceDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ResourceDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public ResourceDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public ResourceDOBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public ResourceDOBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ResourceDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ResourceDOBuilder url(String url) {
            this.url = url;
            return this;
        }

        public ResourceDOBuilder component(String component) {
            this.component = component;
            return this;
        }

        public ResourceDOBuilder resourceType(Integer resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public ResourceDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public ResourceDOBuilder icon(String icon) {
            this.icon = icon;
            return this;
        }

        public ResourceDOBuilder isLeaf(Boolean isLeaf) {
            this.isLeaf = isLeaf;
            return this;
        }

        public ResourceDOBuilder isRoute(Integer isRoute) {
            this.isRoute = isRoute;
            return this;
        }

        public ResourceDOBuilder perms(String perms) {
            this.perms = perms;
            return this;
        }

        public ResourceDOBuilder status(Integer status) {
            this.status = status;
            return this;
        }

        public ResourceDO build() {
            ResourceDO resourceDO = new ResourceDO(this.parentId, this.title, this.name, this.url, this.component, this.resourceType, this.sort, this.icon, this.isLeaf, this.isRoute, this.perms, this.status);
            resourceDO.setId(this.id);
            resourceDO.setDateCreated(this.dateCreated);
            resourceDO.setDateUpdated(this.dateUpdated);
            return resourceDO;
        }
    }
}

