/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class TagDO
extends BaseDO {
    private static final long serialVersionUID = -3968123108441095604L;
    private String name;
    private String tagDesc;
    private String parentTagId;
    private String ext;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTagDesc() {
        return this.tagDesc;
    }

    public void setTagDesc(String tagDesc) {
        this.tagDesc = tagDesc;
    }

    public String getParentTagId() {
        return this.parentTagId;
    }

    public void setParentTagId(String parentTagId) {
        this.parentTagId = parentTagId;
    }

    public String getExt() {
        return this.ext;
    }

    public void setExt(String ext) {
        this.ext = ext;
    }

    public static TagDOBuilder builder() {
        return new TagDOBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagDO tagDO = (TagDO)o;
        return Objects.equals(this.name, tagDO.name) && Objects.equals(this.tagDesc, tagDO.tagDesc) && Objects.equals(this.ext, tagDO.ext) && Objects.equals(this.parentTagId, tagDO.parentTagId);
    }

    public static TagDO buildTagDO(TagDTO tagDTO) {
        return Optional.ofNullable(tagDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            TagDO tagDO = TagDO.builder().parentTagId(tagDTO.getParentTagId()).tagDesc(tagDTO.getTagDesc()).name(tagDTO.getName()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                tagDO.setId(UUIDUtils.getInstance().generateShortUuid());
                tagDO.setDateCreated(currentTime);
            } else {
                tagDO.setId(item.getId());
            }
            return tagDO;
        }).orElse(null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.tagDesc, this.ext, this.parentTagId);
    }

    public static class TagExt
    implements Serializable {
        private String id;
        private String desc;
        private String name;
        private TagExt parent;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public TagExt getParent() {
            return this.parent;
        }

        public void setParent(TagExt parent) {
            this.parent = parent;
        }
    }

    public static final class TagDOBuilder {
        private String id;
        private String name;
        private String tagDesc;
        private String parentTagId;
        private String ext;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private TagDOBuilder() {
        }

        public TagDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TagDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public TagDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public TagDOBuilder tagDesc(String tagDesc) {
            this.tagDesc = tagDesc;
            return this;
        }

        public TagDOBuilder ext(String ext) {
            this.ext = ext;
            return this;
        }

        public TagDOBuilder parentTagId(String parentTagId) {
            this.parentTagId = parentTagId;
            return this;
        }

        public TagDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TagDO build() {
            TagDO tagDO = new TagDO();
            tagDO.setTagDesc(this.tagDesc);
            tagDO.setParentTagId(this.parentTagId);
            tagDO.setName(this.name);
            tagDO.setId(this.id);
            tagDO.setExt(this.ext);
            tagDO.setDateCreated(this.dateCreated);
            tagDO.setDateUpdated(this.dateUpdated);
            return tagDO;
        }
    }
}

