/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.TagRelationDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class TagRelationDO
extends BaseDO {
    private static final long serialVersionUID = -2968123108441795604L;
    private String apiId;
    private String tagId;

    public String getApiId() {
        return this.apiId;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getTagId() {
        return this.tagId;
    }

    public void setTagId(String tagId) {
        this.tagId = tagId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagRelationDO tagRelationDO = (TagRelationDO)o;
        return Objects.equals(this.apiId, tagRelationDO.apiId) && Objects.equals(this.tagId, tagRelationDO.tagId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.apiId, this.tagId);
    }

    public static TagRelationDO buildTagRelationDO(TagRelationDTO tagRelationDTO) {
        return Optional.ofNullable(tagRelationDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            TagRelationDO tagRelationDO = TagRelationDO.builder().apiId(tagRelationDTO.getApiId()).tagId(tagRelationDTO.getTagId()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                tagRelationDO.setId(UUIDUtils.getInstance().generateShortUuid());
                tagRelationDO.setDateCreated(currentTime);
            } else {
                tagRelationDO.setId(item.getId());
            }
            return tagRelationDO;
        }).orElse(null);
    }

    public static TagRelationDOBuilder builder() {
        return new TagRelationDOBuilder();
    }

    public static final class TagRelationDOBuilder {
        private String id;
        private String apiId;
        private String tagId;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;

        private TagRelationDOBuilder() {
        }

        public TagRelationDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public TagRelationDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public TagRelationDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public TagRelationDOBuilder tagId(String tagId) {
            this.tagId = tagId;
            return this;
        }

        public TagRelationDOBuilder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public TagRelationDO build() {
            TagRelationDO tagRelationDO = new TagRelationDO();
            tagRelationDO.setApiId(this.apiId);
            tagRelationDO.setId(this.id);
            tagRelationDO.setTagId(this.tagId);
            tagRelationDO.setDateCreated(this.dateCreated);
            tagRelationDO.setDateUpdated(this.dateUpdated);
            return tagRelationDO;
        }
    }
}

