/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.event;

import java.util.Date;
import java.util.Objects;
import org.apache.shenyu.admin.model.enums.EventTypeEnum;
import org.springframework.context.ApplicationEvent;

public class AdminDataModelChangedEvent
extends ApplicationEvent {
    private final EventTypeEnum type;
    private final Object before;
    private final Object after;
    private final String operator;
    private boolean consumed;
    private final Date date;

    public AdminDataModelChangedEvent(Object source, Object before, EventTypeEnum type) {
        this(source, before, type, null);
    }

    public AdminDataModelChangedEvent(Object source, Object before, EventTypeEnum type, String operator) {
        super(source);
        this.type = type;
        this.before = before;
        this.after = source;
        this.operator = Objects.isNull(operator) ? "unknown" : operator;
        this.consumed = false;
        this.date = new Date();
    }

    public EventTypeEnum getType() {
        return this.type;
    }

    public Object getBefore() {
        return this.before;
    }

    public Object getAfter() {
        return this.after;
    }

    public String getOperator() {
        return this.operator;
    }

    public void consumed() {
        this.consumed = true;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public Date getDate() {
        return this.date;
    }

    public String beforeSnapshot() {
        return Objects.toString(this.before, "before unknown");
    }

    public String afterSnapshot() {
        return Objects.toString(this.after, "after unknown");
    }

    public String buildContext() {
        return String.format("%s changed(%s)[%s = > %s]", this.eventName(), this.type.getTypeName(), this.beforeSnapshot(), this.afterSnapshot());
    }

    public String eventName() {
        return "data";
    }
}

