/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.converter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.service.converter.SelectorHandleConverter;
import org.apache.shenyu.admin.service.impl.UpstreamCheckService;
import org.apache.shenyu.common.dto.convert.selector.CommonUpstream;
import org.apache.shenyu.common.utils.GsonUtils;

public abstract class AbstractSelectorHandleConverter
implements SelectorHandleConverter {
    public static final String EMPTY_LIST_JSON = "[]";

    protected abstract Object doHandle(String var1, List<CommonUpstream> var2);

    @Override
    public String handler(String handle, List<CommonUpstream> aliveList) {
        if ((StringUtils.isEmpty((CharSequence)handle) || EMPTY_LIST_JSON.equals(handle)) && CollectionUtils.isEmpty(aliveList)) {
            return EMPTY_LIST_JSON;
        }
        return GsonUtils.getInstance().toJson(this.doHandle(StringUtils.isEmpty((CharSequence)handle) ? EMPTY_LIST_JSON : handle, aliveList));
    }

    @Override
    public <T extends CommonUpstream> List<T> updateStatusAndFilter(List<T> existList, List<? extends CommonUpstream> aliveList) {
        if (CollectionUtils.isEmpty(aliveList) || CollectionUtils.isEmpty(existList)) {
            return Lists.newArrayList();
        }
        long currentTimeMillis = System.currentTimeMillis();
        List validExistList = existList.stream().filter(e -> e.isStatus() || e.getTimestamp() > currentTimeMillis - TimeUnit.SECONDS.toMillis(UpstreamCheckService.getZombieRemovalTimes()) || aliveList.stream().anyMatch(alive -> alive.getUpstreamUrl().equals(e.getUpstreamUrl()))).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        validExistList.stream().filter(upstream -> !upstream.isStatus() && aliveList.stream().anyMatch(alive -> alive.getUpstreamUrl().equals(upstream.getUpstreamUrl()))).forEach(upstream -> {
            upstream.setStatus(true);
            upstream.setTimestamp(currentTimeMillis);
        });
        validExistList.stream().filter(upstream -> aliveList.stream().noneMatch(alive -> alive.getUpstreamUrl().equals(upstream.getUpstreamUrl()))).forEach(upstream -> {
            upstream.setStatus(false);
            upstream.setTimestamp(currentTimeMillis);
        });
        return validExistList;
    }
}

