/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mapper.ApiMapper;
import org.apache.shenyu.admin.mapper.TagMapper;
import org.apache.shenyu.admin.mapper.TagRelationMapper;
import org.apache.shenyu.admin.model.dto.ApiDTO;
import org.apache.shenyu.admin.model.entity.ApiDO;
import org.apache.shenyu.admin.model.entity.TagDO;
import org.apache.shenyu.admin.model.entity.TagRelationDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.ApiQuery;
import org.apache.shenyu.admin.model.query.TagRelationQuery;
import org.apache.shenyu.admin.model.vo.ApiVO;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.ApiService;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ApiServiceImpl
implements ApiService {
    private final ApiMapper apiMapper;
    private final TagRelationMapper tagRelationMapper;
    private final TagMapper tagMapper;

    public ApiServiceImpl(ApiMapper apiMapper, TagRelationMapper tagRelationMapper, TagMapper tagMapper) {
        this.apiMapper = apiMapper;
        this.tagRelationMapper = tagRelationMapper;
        this.tagMapper = tagMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String createOrUpdate(ApiDTO apiDTO) {
        return StringUtils.isBlank((CharSequence)apiDTO.getId()) ? this.create(apiDTO) : this.update(apiDTO);
    }

    private String update(ApiDTO apiDTO) {
        ApiDO apiDO = ApiDO.buildApiDO(apiDTO);
        int updateRows = this.apiMapper.updateByPrimaryKeySelective(apiDO);
        if (CollectionUtils.isNotEmpty(apiDTO.getTagIds()) && updateRows > 0) {
            List<String> tagIds = apiDTO.getTagIds();
            ArrayList tags = Lists.newArrayList();
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            for (String tagId : tagIds) {
                tags.add(TagRelationDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).apiId(apiDO.getId()).tagId(tagId).dateUpdated(currentTime).build());
            }
            this.tagRelationMapper.deleteByApiId(apiDO.getId());
            this.tagRelationMapper.batchInsert(tags);
        }
        return "update success";
    }

    private String create(ApiDTO apiDTO) {
        ApiDO apiDO = ApiDO.buildApiDO(apiDTO);
        int insertRows = this.apiMapper.insertSelective(apiDO);
        if (CollectionUtils.isNotEmpty(apiDTO.getTagIds()) && insertRows > 0) {
            List<String> tagIds = apiDTO.getTagIds();
            ArrayList tags = Lists.newArrayList();
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            for (String tagId : tagIds) {
                tags.add(TagRelationDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).apiId(apiDO.getId()).tagId(tagId).dateCreated(currentTime).dateUpdated(currentTime).build());
            }
            this.tagRelationMapper.batchInsert(tags);
        }
        return "create success";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String delete(List<String> ids) {
        List<ApiDO> apis = this.apiMapper.selectByIds(ids);
        if (CollectionUtils.isEmpty(apis)) {
            return "The api(s) does not exist\uff01";
        }
        List<String> apiIds = ListUtil.map(apis, ApiDO::getId);
        int deleteRows = this.apiMapper.deleteByIds(apiIds);
        if (deleteRows > 0) {
            this.tagRelationMapper.deleteByApiIds(apiIds);
        }
        return "";
    }

    @Override
    public ApiVO findById(String id) {
        return Optional.ofNullable(this.apiMapper.selectByPrimaryKey(id)).map(item -> {
            List<TagRelationDO> tagRelations = this.tagRelationMapper.selectByQuery(TagRelationQuery.builder().apiId(item.getId()).build());
            List<String> tagIds = tagRelations.stream().map(TagRelationDO::getTagId).collect(Collectors.toList());
            ArrayList tagVOS = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(tagIds)) {
                List<TagDO> tagDOS = this.tagMapper.selectByIds(tagIds);
                for (TagDO tagDO : tagDOS) {
                    tagVOS.add(TagVO.buildTagVO(tagDO));
                }
            }
            return ApiVO.buildApiVO(item, tagVOS);
        }).orElse(null);
    }

    @Override
    public CommonPager<ApiVO> listByPage(ApiQuery apiQuery) {
        return PageResultUtils.result(apiQuery.getPageParameter(), () -> this.apiMapper.selectByQuery(apiQuery).stream().map(item -> {
            List<TagRelationDO> tagRelations = this.tagRelationMapper.selectByQuery(TagRelationQuery.builder().apiId(item.getId()).build());
            List<String> tagIds = tagRelations.stream().map(TagRelationDO::getTagId).collect(Collectors.toList());
            ArrayList tagVOS = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(tagIds)) {
                List<TagDO> tagDOS = this.tagMapper.selectByIds(tagIds);
                for (TagDO tagDO : tagDOS) {
                    tagVOS.add(TagVO.buildTagVO(tagDO));
                }
            }
            return ApiVO.buildApiVO(item, tagVOS);
        }).collect(Collectors.toList()));
    }

    @Override
    public int deleteByApiPathHttpMethodRpcType(String apiPath, Integer httpMethod, String rpcType) {
        List<ApiDO> apiDOs = this.apiMapper.selectByApiPathHttpMethodRpcType(apiPath, httpMethod, rpcType);
        if (CollectionUtils.isNotEmpty(apiDOs)) {
            List<String> apiIds = ListUtil.map(apiDOs, ApiDO::getId);
            int deleteRows = this.apiMapper.deleteByIds(apiIds);
            if (deleteRows > 0) {
                this.tagRelationMapper.deleteByApiIds(apiIds);
            }
            return deleteRows;
        }
        return 0;
    }

    @Override
    public String offlineByContextPath(String contextPath) {
        this.apiMapper.updateOfflineByContextPath(contextPath);
        return "success";
    }
}

