/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.JwtProperties;
import org.apache.shenyu.admin.config.properties.LdapProperties;
import org.apache.shenyu.admin.mapper.DashboardUserMapper;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.mapper.UserRoleMapper;
import org.apache.shenyu.admin.model.dto.DashboardUserDTO;
import org.apache.shenyu.admin.model.dto.DashboardUserModifyPasswordDTO;
import org.apache.shenyu.admin.model.dto.UserRoleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.DashboardUserDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.entity.UserRoleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.DashboardUserQuery;
import org.apache.shenyu.admin.model.vo.DashboardUserEditVO;
import org.apache.shenyu.admin.model.vo.DashboardUserVO;
import org.apache.shenyu.admin.model.vo.LoginDashboardUserVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.service.publish.UserEventPublisher;
import org.apache.shenyu.admin.transfer.DashboardUserTransfer;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.admin.utils.JwtUtils;
import org.apache.shenyu.admin.utils.ListUtil;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.utils.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.support.LdapEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DashboardUserServiceImpl
implements DashboardUserService {
    private static final Logger LOG = LoggerFactory.getLogger(DashboardUserServiceImpl.class);
    private final DashboardUserMapper dashboardUserMapper;
    private final UserRoleMapper userRoleMapper;
    private final RoleMapper roleMapper;
    @Nullable
    private final LdapProperties ldapProperties;
    @Nullable
    private final LdapTemplate ldapTemplate;
    private final JwtProperties jwtProperties;
    private final UserEventPublisher publisher;

    public DashboardUserServiceImpl(DashboardUserMapper dashboardUserMapper, UserRoleMapper userRoleMapper, RoleMapper roleMapper, @Nullable LdapProperties ldapProperties, @Nullable LdapTemplate ldapTemplate, JwtProperties jwtProperties, UserEventPublisher publisher) {
        this.dashboardUserMapper = dashboardUserMapper;
        this.userRoleMapper = userRoleMapper;
        this.roleMapper = roleMapper;
        this.ldapProperties = ldapProperties;
        this.ldapTemplate = ldapTemplate;
        this.jwtProperties = jwtProperties;
        this.publisher = publisher;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(DashboardUserDTO dashboardUserDTO) {
        return StringUtils.isBlank((CharSequence)dashboardUserDTO.getId()) ? this.create(dashboardUserDTO) : this.update(dashboardUserDTO);
    }

    @Override
    public int create(DashboardUserDTO dashboardUserDTO) {
        Assert.notBlack(dashboardUserDTO.getPassword(), "password is not null");
        Assert.notEmpty(dashboardUserDTO.getRoles(), "role is not empty");
        Assert.isNull(this.dashboardUserMapper.selectByUserName(dashboardUserDTO.getUserName()), "the user is existed");
        DashboardUserDO dashboardUserDO = DashboardUserDO.buildDashboardUserDO(dashboardUserDTO);
        int insertCount = this.dashboardUserMapper.insertSelective(dashboardUserDO);
        this.bindUserRole(dashboardUserDO.getId(), dashboardUserDTO.getRoles());
        if (insertCount > 0) {
            this.publisher.onCreated(dashboardUserDO);
        }
        return insertCount;
    }

    @Override
    public int update(DashboardUserDTO dashboardUserDTO) {
        int updateCount;
        Assert.isTrue(SessionUtil.isAdmin(), "This function can only be used by the admin(root) user");
        DashboardUserDO dashboardUserDO = DashboardUserDO.buildDashboardUserDO(dashboardUserDTO);
        if (Objects.equals(dashboardUserDO.getUserName(), SessionUtil.visitorName())) {
            Assert.isTrue(Boolean.TRUE.equals(dashboardUserDO.getEnabled()), "You cannot disable yourself");
        } else {
            Assert.isTrue(!Objects.equals(dashboardUserDO.getId(), SessionUtil.visitor().getUserId()), "Super administrator name is not allowed to be modified");
        }
        if (CollectionUtils.isNotEmpty(dashboardUserDTO.getRoles())) {
            if (!"admin".equals(dashboardUserDTO.getUserName())) {
                this.userRoleMapper.deleteByUserId(dashboardUserDTO.getId());
            }
            this.bindUserRole(dashboardUserDTO.getId(), dashboardUserDTO.getRoles());
        }
        DashboardUserDO before = this.dashboardUserMapper.selectById(dashboardUserDO.getId());
        if (StringUtils.isBlank((CharSequence)dashboardUserDO.getPassword())) {
            dashboardUserDO.setPassword(before.getPassword());
        }
        if ((updateCount = this.dashboardUserMapper.updateSelective(dashboardUserDO)) > 0) {
            this.publisher.onUpdated(dashboardUserDO, before);
        }
        return updateCount;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int delete(Set<String> ids) {
        List<DashboardUserDO> deletedUser = this.dashboardUserMapper.selectByIds(ids).stream().filter(u -> !Objects.equals(u.getUserName(), "admin")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(deletedUser)) {
            return 0;
        }
        List<String> deletedIds = ListUtil.map(deletedUser, BaseDO::getId);
        int deleteCount = this.dashboardUserMapper.deleteByIdList(deletedIds);
        if (deleteCount > 0) {
            this.userRoleMapper.deleteByUserIdList(deletedIds);
            this.publisher.onDeleted((Collection<DashboardUserDO>)deletedUser);
        }
        return deleteCount;
    }

    @Override
    public DashboardUserEditVO findById(String id) {
        DashboardUserVO dashboardUserVO = DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectById(id));
        Set roleIdSet = this.userRoleMapper.findByUserId(id).stream().map(UserRoleDO::getRoleId).collect(Collectors.toSet());
        List<RoleDO> allRoleDOList = this.roleMapper.selectAll();
        List<RoleVO> allRoles = ListUtil.map(allRoleDOList, RoleVO::buildRoleVO);
        List roleDOList = allRoleDOList.stream().filter(roleDO -> roleIdSet.contains(roleDO.getId())).collect(Collectors.toList());
        List<RoleVO> roles = ListUtil.map(roleDOList, RoleVO::buildRoleVO);
        return DashboardUserEditVO.buildDashboardUserEditVO(dashboardUserVO, roles, allRoles);
    }

    @Override
    public DashboardUserVO findByQuery(String userName, String password) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.findByQuery(userName, password));
    }

    @Override
    public DashboardUserVO findByUserName(String userName) {
        return DashboardUserVO.buildDashboardUserVO(this.dashboardUserMapper.selectByUserName(userName));
    }

    @Override
    public CommonPager<DashboardUserVO> listByPage(DashboardUserQuery dashboardUserQuery) {
        return PageResultUtils.result(dashboardUserQuery.getPageParameter(), () -> this.dashboardUserMapper.countByQuery(dashboardUserQuery), () -> ListUtil.map(this.dashboardUserMapper.selectByQuery(dashboardUserQuery), DashboardUserVO::buildDashboardUserVO));
    }

    @Override
    public LoginDashboardUserVO login(String userName, String password) {
        DashboardUserVO dashboardUserVO = null;
        if (Objects.nonNull(this.ldapTemplate)) {
            dashboardUserVO = this.loginByLdap(userName, password);
        }
        if (Objects.isNull(dashboardUserVO)) {
            dashboardUserVO = this.loginByDatabase(userName, password);
        }
        LoginDashboardUserVO loginDashboardUserVO = LoginDashboardUserVO.buildLoginDashboardUserVO(dashboardUserVO);
        DashboardUserVO finalDashboardUserVO = dashboardUserVO;
        return Optional.ofNullable(loginDashboardUserVO).map(loginUser -> {
            if (Boolean.FALSE.equals(loginUser.getEnabled())) {
                return loginUser;
            }
            return loginUser.setToken(JwtUtils.generateToken(finalDashboardUserVO.getUserName(), finalDashboardUserVO.getPassword(), this.jwtProperties.getExpiredSeconds())).setExpiredTime(this.jwtProperties.getExpiredSeconds());
        }).orElse(null);
    }

    @Override
    public int modifyPassword(DashboardUserModifyPasswordDTO dashboardUserModifyPasswordDTO) {
        DashboardUserDO dashboardUserDO = DashboardUserDO.buildDashboardUserDO(dashboardUserModifyPasswordDTO);
        DashboardUserDO before = this.dashboardUserMapper.selectById(dashboardUserDO.getId());
        int updateCount = this.dashboardUserMapper.updateSelective(dashboardUserDO);
        if (updateCount > 0) {
            this.publisher.onUpdated(dashboardUserDO, before);
        }
        return updateCount;
    }

    private DashboardUserVO loginByLdap(String userName, String password) {
        Assert.notNull(this.ldapProperties, "ldap config is not enable");
        String searchBase = String.format("%s=%s,%s", this.ldapProperties.getLoginField(), LdapEncoder.nameEncode((String)userName), this.ldapProperties.getBaseDn());
        String filter = String.format("(objectClass=%s)", this.ldapProperties.getObjectClass());
        try {
            DashboardUserVO dashboardUserVO = null;
            if (Objects.nonNull(this.ldapTemplate) && this.ldapTemplate.authenticate(searchBase, filter, password) && Objects.isNull(dashboardUserVO = this.findByUserName(userName))) {
                RoleDO role = this.roleMapper.findByRoleName("default");
                DashboardUserDTO dashboardUserDTO = DashboardUserDTO.builder().userName(userName).password(DigestUtils.sha512Hex((String)password)).role(1).roles(Lists.newArrayList((Object[])new String[]{role.getId()})).enabled(true).build();
                this.createOrUpdate(dashboardUserDTO);
                dashboardUserVO = DashboardUserTransfer.INSTANCE.transferDTO2VO(dashboardUserDTO);
            }
            return dashboardUserVO;
        }
        catch (NameNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            LOG.error("ldap verify error.", (Throwable)e);
            return null;
        }
    }

    private DashboardUserVO loginByDatabase(String userName, String password) {
        return this.findByQuery(userName, DigestUtils.sha512Hex((String)password));
    }

    private void bindUserRole(String userId, List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds) || StringUtils.isBlank((CharSequence)userId)) {
            return;
        }
        this.userRoleMapper.insertBatch(roleIds.stream().map(roleId -> UserRoleDO.buildUserRoleDO(UserRoleDTO.builder().userId(userId).roleId((String)roleId).build())).collect(Collectors.toList()));
    }
}

