/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.DetailMapper;
import org.apache.shenyu.admin.model.dto.DetailDTO;
import org.apache.shenyu.admin.model.entity.DetailDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.DetailQuery;
import org.apache.shenyu.admin.model.vo.DetailVO;
import org.apache.shenyu.admin.service.DetailService;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;

@Service
public class DetailServiceImpl
implements DetailService {
    private final DetailMapper detailMapper;

    public DetailServiceImpl(DetailMapper detailMapper) {
        this.detailMapper = detailMapper;
    }

    @Override
    public int createOrUpdate(DetailDTO detailDTO) {
        return StringUtils.isBlank((CharSequence)detailDTO.getId()) ? this.create(detailDTO) : this.update(detailDTO);
    }

    @Override
    public int delete(String id) {
        return this.detailMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteBatch(List<String> ids) {
        return this.detailMapper.batchDelete(ids);
    }

    @Override
    public DetailVO findById(String id) {
        DetailDO detailDO = this.detailMapper.selectByPrimaryKey(id);
        DetailVO.DetailVOBuilder builder = DetailVO.builder();
        if (detailDO != null) {
            builder.id(detailDO.getId()).example(detailDO.getExample()).valueDesc(detailDO.getValueDesc()).fieldValue(detailDO.getFieldValue()).fieldId(detailDO.getFieldId()).dateUpdated(detailDO.getDateUpdated()).dateCreated(detailDO.getDateCreated());
        }
        return builder.build();
    }

    @Override
    @Pageable
    public CommonPager<DetailVO> listByPage(DetailQuery detailQuery) {
        return PageResultUtils.result(detailQuery.getPageParameter(), () -> this.detailMapper.selectByQuery(detailQuery).stream().map(DetailVO::buildDetailVO).collect(Collectors.toList()));
    }

    private int create(DetailDTO detailDTO) {
        if (detailDTO == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DetailDO detailDO = DetailDO.builder().id(detailDTO.getId()).example(detailDTO.getExample()).valueDesc(detailDTO.getValueDesc()).fieldValue(detailDTO.getFieldValue()).fieldId(detailDTO.getFieldId()).dateUpdated(currentTime).dateCreated(currentTime).build();
        if (StringUtils.isEmpty((CharSequence)detailDO.getId())) {
            detailDO.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        return this.detailMapper.insert(detailDO);
    }

    private int update(DetailDTO detailDTO) {
        if (detailDTO == null || detailDTO.getId() == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        DetailDO detailDO = DetailDO.builder().id(detailDTO.getId()).example(detailDTO.getExample()).valueDesc(detailDTO.getValueDesc()).fieldValue(detailDTO.getFieldValue()).fieldId(detailDTO.getFieldId()).dateUpdated(currentTime).dateUpdated(currentTime).build();
        return this.detailMapper.updateByPrimaryKeySelective(detailDO);
    }
}

