/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.FieldMapper;
import org.apache.shenyu.admin.model.dto.FieldDTO;
import org.apache.shenyu.admin.model.entity.FieldDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.FieldQuery;
import org.apache.shenyu.admin.model.vo.FieldVO;
import org.apache.shenyu.admin.service.FieldService;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;

@Service
public class FieldServiceImpl
implements FieldService {
    private final FieldMapper fieldMapper;

    public FieldServiceImpl(FieldMapper fieldMapper) {
        this.fieldMapper = fieldMapper;
    }

    @Override
    public int createOrUpdate(FieldDTO fieldDTO) {
        return StringUtils.isBlank((CharSequence)fieldDTO.getId()) ? this.create(fieldDTO) : this.update(fieldDTO);
    }

    @Override
    public int delete(String id) {
        return this.fieldMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteBatch(List<String> ids) {
        return this.fieldMapper.batchDelete(ids);
    }

    @Override
    public FieldVO findById(String id) {
        FieldDO fieldDO = this.fieldMapper.selectByPrimaryKey(id);
        FieldVO.FieldVOBuilder builder = FieldVO.builder();
        if (fieldDO != null) {
            builder.id(fieldDO.getId()).ext(fieldDO.getExt()).fieldDesc(fieldDO.getFieldDesc()).name(fieldDO.getName()).modelId(fieldDO.getModelId()).required(fieldDO.getRequired()).selfModelId(fieldDO.getSelfModelId()).dateUpdated(fieldDO.getDateUpdated()).dateCreated(fieldDO.getDateCreated());
        }
        return builder.build();
    }

    @Override
    @Pageable
    public CommonPager<FieldVO> listByPage(FieldQuery fieldQuery) {
        List<FieldDO> list = this.fieldMapper.selectByQuery(fieldQuery);
        return PageResultUtils.result(fieldQuery.getPageParameter(), () -> list.stream().map(FieldVO::buildFieldVO).collect(Collectors.toList()));
    }

    private int create(FieldDTO fieldDTO) {
        if (fieldDTO == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        FieldDO fieldDO = FieldDO.builder().id(fieldDTO.getId()).ext(fieldDTO.getExt()).fieldDesc(fieldDTO.getFieldDesc()).name(fieldDTO.getName()).modelId(fieldDTO.getModelId()).required(fieldDTO.getRequired()).selfModelId(fieldDTO.getSelfModelId()).dateUpdated(currentTime).dateCreated(currentTime).build();
        if (StringUtils.isEmpty((CharSequence)fieldDO.getId())) {
            fieldDO.setId(UUIDUtils.getInstance().generateShortUuid());
        }
        return this.fieldMapper.insert(fieldDO);
    }

    private int update(FieldDTO fieldDTO) {
        if (fieldDTO == null || fieldDTO.getId() == null) {
            return 0;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        FieldDO fieldDO = FieldDO.builder().id(fieldDTO.getId()).ext(fieldDTO.getExt()).fieldDesc(fieldDTO.getFieldDesc()).name(fieldDTO.getName()).modelId(fieldDTO.getModelId()).required(fieldDTO.getRequired()).selfModelId(fieldDTO.getSelfModelId()).dateUpdated(currentTime).build();
        return this.fieldMapper.updateByPrimaryKeySelective(fieldDO);
    }
}

