/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.config.properties.DashboardProperties;
import org.apache.shenyu.admin.mapper.PermissionMapper;
import org.apache.shenyu.admin.mapper.ResourceMapper;
import org.apache.shenyu.admin.mapper.RoleMapper;
import org.apache.shenyu.admin.model.dto.RoleDTO;
import org.apache.shenyu.admin.model.entity.PermissionDO;
import org.apache.shenyu.admin.model.entity.RoleDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.RoleQuery;
import org.apache.shenyu.admin.model.vo.ResourceVO;
import org.apache.shenyu.admin.model.vo.RoleEditVO;
import org.apache.shenyu.admin.model.vo.RoleVO;
import org.apache.shenyu.admin.service.RoleService;
import org.apache.shenyu.admin.service.publish.RoleEventPublisher;
import org.apache.shenyu.admin.utils.ListUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    private final RoleMapper roleMapper;
    private final DashboardProperties properties;
    private final PermissionMapper permissionMapper;
    private final ResourceMapper resourceMapper;
    private final RoleEventPublisher roleEventPublisher;

    public RoleServiceImpl(RoleMapper roleMapper, DashboardProperties properties, PermissionMapper permissionMapper, ResourceMapper resourceMapper, RoleEventPublisher roleEventPublisher) {
        this.roleMapper = roleMapper;
        this.properties = properties;
        this.permissionMapper = permissionMapper;
        this.resourceMapper = resourceMapper;
        this.roleEventPublisher = roleEventPublisher;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int createOrUpdate(RoleDTO roleDTO) {
        return RoleService.super.createOrUpdate(roleDTO);
    }

    @Override
    public int create(RoleDTO roleDTO) {
        RoleDO role = RoleDO.buildRoleDO(roleDTO);
        int insertCount = this.roleMapper.insertSelective(role);
        if (insertCount > 0) {
            this.roleEventPublisher.onCreated(role);
        }
        return insertCount;
    }

    @Override
    public int update(RoleDTO roleDTO) {
        RoleDO before = this.roleMapper.selectById(roleDTO.getId());
        RoleDO role = RoleDO.buildRoleDO(roleDTO);
        int updateCount = this.roleMapper.updateSelective(role);
        if (updateCount > 0) {
            this.roleEventPublisher.onUpdated(role, before, roleDTO.getCurrentPermissionIds());
        }
        return updateCount;
    }

    @Override
    public int delete(List<String> ids) {
        List<RoleDO> roles = this.roleMapper.selectByIds(ids);
        int deleteCount = this.roleMapper.delete(ids);
        if (deleteCount > 0) {
            this.roleEventPublisher.onDeleted((Collection<RoleDO>)roles);
        }
        return deleteCount;
    }

    @Override
    public RoleEditVO findById(String id) {
        RoleVO sysRole = RoleVO.buildRoleVO(this.roleMapper.selectById(id));
        return Optional.ofNullable(sysRole).map(item -> new RoleEditVO(this.getPermissionIdsByRoleId(item.getId()), (RoleVO)item, this.getAllPermissions())).orElse(null);
    }

    @Override
    public RoleVO findByQuery(String roleName) {
        return RoleVO.buildRoleVO(this.roleMapper.findByRoleName(roleName));
    }

    @Override
    @Pageable
    public CommonPager<RoleVO> listByPage(RoleQuery roleQuery) {
        return PageResultUtils.result(roleQuery.getPageParameter(), () -> this.roleMapper.selectByQuery(roleQuery).stream().map(RoleVO::buildRoleVO).collect(Collectors.toList()));
    }

    @Override
    public List<RoleVO> selectAll() {
        return ListUtil.map(this.roleMapper.selectAll(), RoleVO::buildRoleVO);
    }

    private RoleEditVO.PermissionInfo getAllPermissions() {
        List<ResourceVO> resourceVOList = this.resourceMapper.selectAll().stream().filter(r -> !this.properties.getOnlySuperAdminPermission().contains(r.getPerms())).map(ResourceVO::buildResourceVO).collect(Collectors.toList());
        return RoleEditVO.PermissionInfo.builder().treeList(this.getTreeModelList(resourceVOList)).permissionIds(ListUtil.map(resourceVOList, ResourceVO::getId)).build();
    }

    private List<String> getPermissionIdsByRoleId(String roleId) {
        return ListUtil.map(this.permissionMapper.findByObjectId(roleId), PermissionDO::getResourceId);
    }

    private List<RoleEditVO.ResourceInfo> getTreeModelList(List<ResourceVO> metaList) {
        ArrayList<RoleEditVO.ResourceInfo> retList = new ArrayList<RoleEditVO.ResourceInfo>();
        if (CollectionUtils.isEmpty(metaList)) {
            return retList;
        }
        Map resourceInfoMap = metaList.stream().map(RoleEditVO.ResourceInfo::buildResourceInfo).filter(resourceInfo -> Objects.nonNull(resourceInfo) && StringUtils.isNotEmpty((CharSequence)resourceInfo.getId())).collect(Collectors.toMap(RoleEditVO.ResourceInfo::getId, Function.identity(), (value1, value2) -> value1));
        Map metaChildrenMap = metaList.stream().filter(meta -> Objects.nonNull(meta) && StringUtils.isNotEmpty((CharSequence)meta.getId())).collect(Collectors.toMap(ResourceVO::getParentId, resourceVO -> new LinkedHashSet<String>(Collections.singletonList(resourceVO.getId())), ListUtil::mergeSet, LinkedHashMap::new));
        metaChildrenMap.forEach((parent, children) -> {
            if (CollectionUtils.isNotEmpty((Collection)children)) {
                RoleEditVO.ResourceInfo resourceInfo = (RoleEditVO.ResourceInfo)resourceInfoMap.get(parent);
                List<RoleEditVO.ResourceInfo> targetList = Objects.isNull(resourceInfo) ? retList : resourceInfo.getChildren();
                children.forEach(child -> {
                    RoleEditVO.ResourceInfo data = (RoleEditVO.ResourceInfo)resourceInfoMap.get(child);
                    if (Objects.nonNull(data)) {
                        targetList.add(data);
                    }
                });
            }
        });
        return retList;
    }
}

