/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.apache.shenyu.admin.mapper.TagRelationMapper;
import org.apache.shenyu.admin.model.dto.TagRelationDTO;
import org.apache.shenyu.admin.model.entity.TagRelationDO;
import org.apache.shenyu.admin.model.query.TagRelationQuery;
import org.apache.shenyu.admin.service.TagRelationService;
import org.apache.shenyu.admin.utils.Assert;
import org.springframework.stereotype.Service;

@Service
public class TagRelationServiceImpl
implements TagRelationService {
    private TagRelationMapper tagRelationMapper;

    public TagRelationServiceImpl(TagRelationMapper tagRelationMapper) {
        this.tagRelationMapper = tagRelationMapper;
    }

    @Override
    public int create(TagRelationDTO tagRelationDTO) {
        TagRelationDO tagRelationDO = TagRelationDO.buildTagRelationDO(tagRelationDTO);
        return this.tagRelationMapper.insert(tagRelationDO);
    }

    @Override
    public int update(TagRelationDTO tagRelationDTO) {
        TagRelationDO before = this.tagRelationMapper.selectByPrimaryKey(tagRelationDTO.getId());
        Assert.notNull(before, "the updated rule is not found");
        TagRelationDO tagRelationDO = TagRelationDO.buildTagRelationDO(tagRelationDTO);
        return this.tagRelationMapper.updateByPrimaryKeySelective(tagRelationDO);
    }

    @Override
    public int delete(List<String> ids) {
        return this.tagRelationMapper.deleteByIds(ids);
    }

    @Override
    public TagRelationDO findById(String id) {
        return this.tagRelationMapper.selectByPrimaryKey(id);
    }

    @Override
    public List<TagRelationDO> findByTagId(String tagId) {
        TagRelationQuery tagRelationQuery = new TagRelationQuery();
        tagRelationQuery.setTagId(tagId);
        return Optional.ofNullable(this.tagRelationMapper.selectByQuery(tagRelationQuery)).orElse(Lists.newArrayList());
    }

    @Override
    public List<TagRelationDO> findApiId(String apiId) {
        TagRelationQuery tagRelationQuery = new TagRelationQuery();
        tagRelationQuery.setApiId(apiId);
        return Optional.ofNullable(this.tagRelationMapper.selectByQuery(tagRelationQuery)).orElse(Lists.newArrayList());
    }
}

