/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.mapper.TagMapper;
import org.apache.shenyu.admin.model.dto.TagDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.TagDO;
import org.apache.shenyu.admin.model.query.TagQuery;
import org.apache.shenyu.admin.model.vo.TagVO;
import org.apache.shenyu.admin.service.TagService;
import org.apache.shenyu.admin.utils.Assert;
import org.apache.shenyu.common.utils.GsonUtils;
import org.springframework.stereotype.Service;

@Service
public class TagServiceImpl
implements TagService {
    private TagMapper tagMapper;

    public TagServiceImpl(TagMapper tagMapper) {
        this.tagMapper = tagMapper;
    }

    @Override
    public int create(TagDTO tagDTO) {
        TagDO tagDO;
        Assert.notNull(tagDTO, "tagDTO is not allowed null");
        Assert.notNull(tagDTO.getParentTagId(), "parent tag id is not allowed null");
        String ext = "";
        if (!tagDTO.getParentTagId().equals("0")) {
            tagDO = this.tagMapper.selectByPrimaryKey(tagDTO.getParentTagId());
            ext = this.buildExtParamByParentTag(tagDO);
        }
        tagDO = TagDO.buildTagDO(tagDTO);
        tagDO.setExt(ext);
        return this.tagMapper.insert(tagDO);
    }

    @Override
    public int update(TagDTO tagDTO) {
        TagDO before = this.tagMapper.selectByPrimaryKey(tagDTO.getId());
        Assert.notNull(before, "the updated tag is not found");
        TagDO tagDO = TagDO.buildTagDO(tagDTO);
        this.updateSubTags(tagDTO);
        return this.tagMapper.updateByPrimaryKeySelective(tagDO);
    }

    @Override
    public int delete(List<String> ids) {
        return this.tagMapper.deleteByIds(ids);
    }

    @Override
    public TagVO findById(String id) {
        TagDO tagDO = this.tagMapper.selectByPrimaryKey(id);
        return TagVO.buildTagVO(tagDO);
    }

    @Override
    public List<TagVO> findByQuery(String tagName) {
        TagQuery tagQuery = new TagQuery();
        tagQuery.setName(tagName);
        List<TagDO> tagDOS = Optional.ofNullable(this.tagMapper.selectByQuery(tagQuery)).orElse(Lists.newArrayList());
        return tagDOS.stream().map(TagVO::buildTagVO).collect(Collectors.toList());
    }

    @Override
    public List<TagVO> findByParentTagId(String parentTagId) {
        TagQuery tagQuery = new TagQuery();
        tagQuery.setParentTagId(parentTagId);
        List<TagDO> tagDOS = this.tagMapper.selectByQuery(tagQuery);
        if (CollectionUtils.isEmpty(tagDOS)) {
            return Lists.newArrayList();
        }
        List<String> rootIds = tagDOS.stream().map(BaseDO::getId).collect(Collectors.toList());
        List<TagDO> tagDOList = this.tagMapper.selectByParentTagIds(rootIds);
        ConcurrentHashMap map = new ConcurrentHashMap();
        tagDOList.forEach(tagDO -> map.put(tagDO.getParentTagId(), true));
        return tagDOS.stream().map(tag -> {
            TagVO tagVO = TagVO.buildTagVO(tag);
            if (map.get(tag.getId()) != null) {
                tagVO.setHasChildren((Boolean)map.get(tag.getId()));
            }
            return tagVO;
        }).collect(Collectors.toList());
    }

    private void updateSubTags(TagDTO tagDTO) {
        List<TagDO> allData = this.tagMapper.selectByQuery(new TagQuery());
        ConcurrentHashMap<String, TagDO> allDataMap = new ConcurrentHashMap<String, TagDO>();
        allData.stream().forEach(tagDO -> allDataMap.put(tagDO.getId(), (TagDO)tagDO));
        TagDO update = TagDO.buildTagDO(tagDTO);
        allDataMap.put(update.getId(), update);
        ConcurrentHashMap<String, List<String>> relationMap = new ConcurrentHashMap<String, List<String>>();
        allDataMap.keySet().forEach(tagId -> {
            TagDO tagDO = (TagDO)allDataMap.get(tagId);
            if (CollectionUtils.isEmpty((Collection)((Collection)relationMap.get(tagDO.getParentTagId())))) {
                relationMap.put(tagDO.getParentTagId(), Lists.newArrayList((Object[])new String[]{tagDO.getId()}));
            } else {
                List list = (List)relationMap.get(tagDO.getParentTagId());
                list.add(tagDO.getId());
                relationMap.put(tagDO.getParentTagId(), list);
            }
        });
        this.recurseUpdateTag(allDataMap, relationMap, tagDTO.getId());
    }

    private void recurseUpdateTag(Map<String, TagDO> allData, Map<String, List<String>> relationMap, String id) {
        if (CollectionUtils.isEmpty((Collection)relationMap.get(id))) {
            return;
        }
        List<String> subTagIds = relationMap.get(id);
        subTagIds.stream().forEach(tagId -> {
            TagDO tagDO = (TagDO)allData.get(tagId);
            tagDO.setExt(this.buildExtParamByParentTag((TagDO)allData.get(id)));
            this.tagMapper.updateByPrimaryKey(tagDO);
            this.recurseUpdateTag(allData, relationMap, (String)tagId);
        });
    }

    private String buildExtParamByParentTag(TagDO parentTagDO) {
        String ext = "";
        if (parentTagDO.getId().equals("0")) {
            TagDO.TagExt parent = new TagDO.TagExt();
            TagDO.TagExt tagExt = new TagDO.TagExt();
            tagExt.setDesc(parentTagDO.getTagDesc());
            tagExt.setName(parentTagDO.getName());
            tagExt.setId(parentTagDO.getId());
            parent.setParent(tagExt);
            ext = GsonUtils.getInstance().toJson((Object)parent);
        } else {
            TagDO.TagExt parentTagExt = Optional.ofNullable((TagDO.TagExt)GsonUtils.getInstance().fromJson(parentTagDO.getExt(), TagDO.TagExt.class)).orElse(new TagDO.TagExt());
            TagDO.TagExt tagExt = new TagDO.TagExt();
            parentTagExt.setDesc(parentTagDO.getTagDesc());
            parentTagExt.setName(parentTagDO.getName());
            parentTagExt.setId(parentTagDO.getId());
            tagExt.setParent(parentTagExt);
            ext = GsonUtils.getInstance().toJson((Object)tagExt);
        }
        return ext;
    }
}

