/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import java.util.Optional;
import org.apache.shenyu.admin.model.custom.UserInfo;
import org.apache.shiro.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JwtUtils.class);
    private static final long TOKEN_EXPIRE_SECONDS = 86400000L;

    private JwtUtils() {
    }

    public static UserInfo getUserInfo() {
        return (UserInfo)SecurityUtils.getSubject().getPrincipal();
    }

    public static String getIssuer(String token) {
        DecodedJWT jwt = JWT.decode((String)token);
        return Optional.of(jwt).map(item -> item.getClaim("userName").asString()).orElse("");
    }

    public static String generateToken(String userName, String key) {
        return JwtUtils.generateToken(userName, key, null);
    }

    public static String generateToken(String userName, String key, Long expireSeconds) {
        try {
            return JWT.create().withClaim("userName", userName).withExpiresAt(new Date(System.currentTimeMillis() + Optional.ofNullable(expireSeconds).orElse(86400000L))).sign(Algorithm.HMAC256((String)key));
        }
        catch (JWTCreationException | IllegalArgumentException e) {
            LOG.error("JWTToken generate fail ", e);
            return "";
        }
    }

    public static boolean verifyToken(String token, String key) {
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.HMAC256((String)key)).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException e) {
            LOG.info("jwt decode fail, token: {} ", (Object)token, (Object)e);
            return false;
        }
    }
}

