/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;

public final class ListUtil {
    private ListUtil() {
    }

    @SafeVarargs
    public static <T> List<T> list(T ... t) {
        return Stream.of(t).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <T> List<T> of(T ... t) {
        return Collections.unmodifiableList(Stream.of(t).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static <T> List<T> emptyIsDefault(List<T> list, List<T> defaultV) {
        return CollectionUtils.isEmpty(list) ? defaultV : list;
    }

    public static <R, T> List<T> map(Collection<R> list, Function<? super R, ? extends T> function) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(Objects::nonNull).map(function).collect(Collectors.toList());
    }

    public static <R> R findFirst(List<R> list, Function<R, Boolean> function) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (R r : list) {
            if (!Boolean.TRUE.equals(function.apply(r))) continue;
            return r;
        }
        return null;
    }

    public static <K, U> Map<K, U> toMap(Collection<U> list, Function<? super U, ? extends K> function) {
        return ListUtil.toMap(list, function, Function.identity());
    }

    public static <K, U, T> Map<K, U> toMap(Collection<T> list, Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.toMap(keyMapper, valueMapper, (value1, value2) -> value1));
    }

    public static <K, U> Map<K, List<U>> groupBy(Collection<U> list, Function<? super U, ? extends K> function) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyMap();
        }
        return list.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(function));
    }

    public static <T> Set<T> mergeSet(Set<T> set1, Set<T> set2) {
        set1.addAll(set2);
        return set1;
    }

    public static <T> List<T> merge(List<T> list1, List<T> list2) {
        list1.addAll(list2);
        return list1;
    }
}

