/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.dto.DetailDTO;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.DetailQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.DetailService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/detail"})
public class DetailController {
    private final DetailService detailService;

    public DetailController(DetailService detailService) {
        this.detailService = detailService;
    }

    @PostMapping(value={"/insertOrUpdate"})
    public ShenyuAdminResult createOrUpdate(@Valid @RequestBody DetailDTO detailDTO) {
        return ShenyuAdminResult.success("success", this.detailService.createOrUpdate(detailDTO));
    }

    @DeleteMapping(value={"/batchDelete"})
    public ShenyuAdminResult batchDelete(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        Integer deleteCount = this.detailService.deleteBatch(ids);
        return ShenyuAdminResult.success("delete success", deleteCount);
    }

    @GetMapping(value={"/findPageByQuery"})
    public ShenyuAdminResult listByPage(String fieldValue, String valueDesc, @RequestParam @NotNull(message="currentPage not null") @NotNull(message="currentPage not null") Integer currentPage, @RequestParam @NotNull(message="pageSize not null") @NotNull(message="pageSize not null") Integer pageSize) {
        PageParameter pageParameter = new PageParameter(currentPage, pageSize);
        return ShenyuAdminResult.success("query success", this.detailService.listByPage(new DetailQuery(fieldValue, valueDesc, pageParameter)));
    }
}

