/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import java.util.Optional;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.LoginDashboardUserVO;
import org.apache.shenyu.admin.service.DashboardUserService;
import org.apache.shenyu.admin.service.EnumService;
import org.springframework.web.bind.annotation.GetMapping;

@RestApi(value={"/platform"})
public class PlatformController {
    private final DashboardUserService dashboardUserService;
    private final EnumService enumService;

    public PlatformController(DashboardUserService dashboardUserService, EnumService enumService) {
        this.dashboardUserService = dashboardUserService;
        this.enumService = enumService;
    }

    @GetMapping(value={"/login"})
    public ShenyuAdminResult loginDashboardUser(String userName, String password) {
        LoginDashboardUserVO loginVO = this.dashboardUserService.login(userName, password);
        return Optional.ofNullable(loginVO).map(loginStatus -> {
            if (Boolean.TRUE.equals(loginStatus.getEnabled())) {
                return ShenyuAdminResult.success("login dashboard user success", loginVO);
            }
            return ShenyuAdminResult.error("the user is disabled");
        }).orElse(ShenyuAdminResult.error("username or password error"));
    }

    @GetMapping(value={"/enum"})
    public ShenyuAdminResult queryEnums() {
        return ShenyuAdminResult.success(this.enumService.list());
    }
}

