/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.DefaultDiscoveryProcessor;
import org.apache.shenyu.admin.discovery.DiscoveryDataChangedEventSyncListener;
import org.apache.shenyu.admin.discovery.DiscoveryProcessor;
import org.apache.shenyu.admin.discovery.parse.CustomDiscoveryUpstreamParser;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.dto.DiscoveryHandlerDTO;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.dto.ProxySelectorDTO;
import org.apache.shenyu.admin.model.entity.DiscoveryDO;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shenyu.discovery.api.ShenyuDiscoveryService;
import org.apache.shenyu.discovery.api.config.DiscoveryConfig;
import org.apache.shenyu.discovery.api.listener.DataChangedEventListener;
import org.apache.shenyu.spi.ExtensionLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public abstract class AbstractDiscoveryProcessor
implements DiscoveryProcessor,
ApplicationEventPublisherAware {
    protected static final String DEFAULT_LISTENER_NODE = "/shenyu/discovery";
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultDiscoveryProcessor.class);
    private final Map<String, ShenyuDiscoveryService> discoveryServiceCache;
    private final Map<String, Set<String>> dataChangedEventListenerCache;
    private ApplicationEventPublisher eventPublisher;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;

    public AbstractDiscoveryProcessor(DiscoveryUpstreamMapper discoveryUpstreamMapper) {
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoveryServiceCache = new ConcurrentHashMap<String, ShenyuDiscoveryService>();
        this.dataChangedEventListenerCache = new ConcurrentHashMap<String, Set<String>>();
    }

    @Override
    public void createDiscovery(DiscoveryDO discoveryDO) {
        if (this.discoveryServiceCache.containsKey(discoveryDO.getId())) {
            LOG.info("shenyu DiscoveryProcessor {} discovery has been init", (Object)discoveryDO.getId());
            return;
        }
        String type = discoveryDO.getType();
        String props = discoveryDO.getProps();
        Properties properties = (Properties)GsonUtils.getGson().fromJson(props, Properties.class);
        DiscoveryConfig discoveryConfig = new DiscoveryConfig();
        discoveryConfig.setType(type);
        discoveryConfig.setProps(properties);
        discoveryConfig.setServerList(discoveryDO.getServerList());
        ShenyuDiscoveryService discoveryService = (ShenyuDiscoveryService)ExtensionLoader.getExtensionLoader(ShenyuDiscoveryService.class).getJoin(type);
        discoveryService.init(discoveryConfig);
        this.discoveryServiceCache.put(discoveryDO.getId(), discoveryService);
        this.dataChangedEventListenerCache.put(discoveryDO.getId(), new HashSet());
    }

    @Override
    public void removeDiscovery(DiscoveryDO discoveryDO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.remove(discoveryDO.getId());
        if (shenyuDiscoveryService == null) {
            return;
        }
        if (this.discoveryServiceCache.values().stream().noneMatch(p -> p.equals(shenyuDiscoveryService))) {
            shenyuDiscoveryService.shutdown();
            LOG.info("shenyu discovery shutdown [{}] discovery", (Object)discoveryDO.getName());
        }
    }

    @Override
    public void removeProxySelector(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryHandlerDTO.getDiscoveryId());
        String key = this.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode());
        Optional.ofNullable(this.dataChangedEventListenerCache.get(discoveryHandlerDTO.getDiscoveryId())).ifPresent(cacheKey -> {
            cacheKey.remove(key);
            shenyuDiscoveryService.unwatch(key);
            DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.PROXY_SELECTOR, DataEventTypeEnum.DELETE, Collections.singletonList(DiscoveryTransfer.INSTANCE.mapToData(proxySelectorDTO)));
            this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
        });
    }

    @Override
    public void changeUpstream(ProxySelectorDTO proxySelectorDTO, List<DiscoveryUpstreamDTO> upstreamDTOS) {
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setPluginName(proxySelectorDTO.getPluginName());
        discoverySyncData.setSelectorId(proxySelectorDTO.getId());
        discoverySyncData.setSelectorName(proxySelectorDTO.getName());
        List upstreamDataList = upstreamDTOS.stream().map(DiscoveryTransfer.INSTANCE::mapToData).collect(Collectors.toList());
        discoverySyncData.setUpstreamDataList(upstreamDataList);
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    @Override
    public void fetchAll(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        String discoveryId = discoveryHandlerDTO.getDiscoveryId();
        if (this.discoveryServiceCache.containsKey(discoveryId)) {
            ShenyuDiscoveryService shenyuDiscoveryService = this.discoveryServiceCache.get(discoveryId);
            List childData = shenyuDiscoveryService.getRegisterData(this.buildProxySelectorKey(discoveryHandlerDTO.getListenerNode()));
            List discoveryUpstreamDataList = childData.stream().map(s -> (DiscoveryUpstreamData)GsonUtils.getGson().fromJson(s, DiscoveryUpstreamData.class)).collect(Collectors.toList());
            Set urlList = discoveryUpstreamDataList.stream().map(DiscoveryUpstreamData::getUrl).collect(Collectors.toSet());
            List<DiscoveryUpstreamDO> discoveryUpstreamDOS = this.discoveryUpstreamMapper.selectByDiscoveryHandlerId(discoveryHandlerDTO.getId());
            Set dbUrlList = discoveryUpstreamDOS.stream().map(DiscoveryUpstreamDO::getUrl).collect(Collectors.toSet());
            ArrayList<String> deleteIds = new ArrayList<String>();
            for (DiscoveryUpstreamDO discoveryUpstreamDO : discoveryUpstreamDOS) {
                if (urlList.contains(discoveryUpstreamDO.getUrl())) continue;
                deleteIds.add(discoveryUpstreamDO.getId());
            }
            if (!deleteIds.isEmpty()) {
                this.discoveryUpstreamMapper.deleteByIds(deleteIds);
            }
            for (DiscoveryUpstreamData currDiscoveryUpstreamDate : discoveryUpstreamDataList) {
                if (dbUrlList.contains(currDiscoveryUpstreamDate.getUrl())) continue;
                DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryTransfer.INSTANCE.mapToDo(currDiscoveryUpstreamDate);
                discoveryUpstreamDO.setId(UUIDUtils.getInstance().generateShortUuid());
                discoveryUpstreamDO.setDiscoveryHandlerId(discoveryHandlerDTO.getId());
                discoveryUpstreamDO.setDateCreated(new Timestamp(System.currentTimeMillis()));
                discoveryUpstreamDO.setDateUpdated(new Timestamp(System.currentTimeMillis()));
                this.discoveryUpstreamMapper.insert(discoveryUpstreamDO);
            }
            DiscoverySyncData discoverySyncData = new DiscoverySyncData();
            discoverySyncData.setSelectorId(proxySelectorDTO.getId());
            discoverySyncData.setSelectorName(proxySelectorDTO.getName());
            discoverySyncData.setPluginName(proxySelectorDTO.getPluginName());
            discoverySyncData.setUpstreamDataList(discoveryUpstreamDataList);
            DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(discoverySyncData));
            this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
        }
    }

    protected String buildProxySelectorKey(String listenerNode) {
        return StringUtils.isNotBlank((CharSequence)listenerNode) ? listenerNode : DEFAULT_LISTENER_NODE;
    }

    public DataChangedEventListener getDiscoveryDataChangedEventListener(DiscoveryHandlerDTO discoveryHandlerDTO, ProxySelectorDTO proxySelectorDTO) {
        Map customMap = GsonUtils.getInstance().toObjectMap(discoveryHandlerDTO.getHandler(), String.class);
        DiscoverySyncData discoverySyncData = new DiscoverySyncData();
        discoverySyncData.setPluginName(proxySelectorDTO.getPluginName());
        discoverySyncData.setSelectorName(proxySelectorDTO.getName());
        discoverySyncData.setSelectorId(proxySelectorDTO.getId());
        return new DiscoveryDataChangedEventSyncListener(this.eventPublisher, this.discoveryUpstreamMapper, new CustomDiscoveryUpstreamParser(customMap), discoveryHandlerDTO.getId(), discoverySyncData);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public ShenyuDiscoveryService getShenyuDiscoveryService(String discoveryId) {
        return this.discoveryServiceCache.get(discoveryId);
    }

    public Set<String> getCacheKey(String discoveryId) {
        return this.dataChangedEventListenerCache.get(discoveryId);
    }

    public void publishEvent(DataChangedEvent dataChangedEvent) {
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }
}

