/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery.parse;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.parse.KeyValueParser;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDiscoveryUpstreamParser
implements JsonDeserializer<DiscoveryUpstreamData>,
KeyValueParser {
    private static final Logger LOG = LoggerFactory.getLogger(CustomDiscoveryUpstreamParser.class);
    private final Map<String, String> conversion;

    public CustomDiscoveryUpstreamParser(Map<String, String> conversion) {
        this.conversion = conversion;
    }

    public DiscoveryUpstreamData deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject asJsonObject = jsonElement.getAsJsonObject();
        JsonObject afterJson = new JsonObject();
        for (Map.Entry elementEntry : asJsonObject.entrySet()) {
            String key = (String)elementEntry.getKey();
            if (this.conversion.containsKey(key)) {
                String transferKey = this.conversion.get(key);
                afterJson.add(transferKey, (JsonElement)elementEntry.getValue());
                continue;
            }
            afterJson.add(key, (JsonElement)elementEntry.getValue());
        }
        return (DiscoveryUpstreamData)GsonUtils.getInstance().fromJson((JsonElement)afterJson, DiscoveryUpstreamData.class);
    }

    @Override
    public List<DiscoveryUpstreamData> parseValue(String jsonString) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return Collections.emptyList();
        }
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(DiscoveryUpstreamData.class, (Object)this);
        Gson gson = gsonBuilder.create();
        return Collections.singletonList(gson.fromJson(jsonString, DiscoveryUpstreamData.class));
    }
}

