/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.disruptor.subscriber;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.service.register.ShenyuClientRegisterService;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.subsriber.ExecutorTypeSubscriber;
import org.apache.shenyu.register.common.type.DataType;

public class URIRegisterExecutorSubscriber
implements ExecutorTypeSubscriber<URIRegisterDTO> {
    private final Map<String, ShenyuClientRegisterService> shenyuClientRegisterService;

    public URIRegisterExecutorSubscriber(Map<String, ShenyuClientRegisterService> shenyuClientRegisterService) {
        this.shenyuClientRegisterService = shenyuClientRegisterService;
    }

    public DataType getType() {
        return DataType.URI;
    }

    public void executor(Collection<URIRegisterDTO> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        Map<String, List<URIRegisterDTO>> groupByRpcType = dataList.stream().filter(data -> StringUtils.isNotBlank((CharSequence)data.getRpcType())).collect(Collectors.groupingBy(URIRegisterDTO::getRpcType));
        for (Map.Entry<String, List<URIRegisterDTO>> entry : groupByRpcType.entrySet()) {
            String rpcType = entry.getKey();
            Optional.ofNullable(this.shenyuClientRegisterService.get(rpcType)).ifPresent(service -> {
                List list = (List)entry.getValue();
                Map<String, List<URIRegisterDTO>> listMap = this.buildData(list);
                listMap.forEach((selectorName, uriList) -> {
                    LinkedList<URIRegisterDTO> register = new LinkedList<URIRegisterDTO>();
                    LinkedList<URIRegisterDTO> offline = new LinkedList<URIRegisterDTO>();
                    for (URIRegisterDTO d : uriList) {
                        EventType eventType = d.getEventType();
                        if (Objects.isNull(eventType) || EventType.REGISTER.equals((Object)eventType)) {
                            register.add(d);
                            continue;
                        }
                        if (!EventType.OFFLINE.equals((Object)eventType)) continue;
                        offline.add(d);
                    }
                    if (CollectionUtils.isNotEmpty(register)) {
                        service.registerURI((String)selectorName, (List<URIRegisterDTO>)register);
                    }
                    if (CollectionUtils.isNotEmpty(offline)) {
                        service.offline((String)selectorName, (List<URIRegisterDTO>)offline);
                    }
                });
            });
        }
    }

    private Map<String, List<URIRegisterDTO>> buildData(Collection<URIRegisterDTO> dataList) {
        HashMap<String, List<URIRegisterDTO>> resultMap = new HashMap<String, List<URIRegisterDTO>>(8);
        for (URIRegisterDTO dto : dataList) {
            String contextPath = dto.getContextPath();
            String key = StringUtils.isNotEmpty((CharSequence)contextPath) ? contextPath : dto.getAppName();
            if (!StringUtils.isNotEmpty((CharSequence)key)) continue;
            if (resultMap.containsKey(key)) {
                List existList = (List)resultMap.get(key);
                existList.add(dto);
                resultMap.put(key, existList);
                continue;
            }
            resultMap.put(key, Lists.newArrayList((Object[])new URIRegisterDTO[]{dto}));
        }
        return resultMap;
    }
}

