/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.lock.impl;

import org.apache.shenyu.admin.lock.RegisterExecutionLock;
import org.apache.shenyu.admin.lock.util.RegisterTransactionUtil;
import org.apache.shenyu.admin.mapper.PluginMapper;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class ForUpdateBackedRegisterExecutionLock
implements RegisterExecutionLock {
    private final PlatformTransactionManager transactionManager;
    private final PluginMapper pluginMapper;
    private final String name;
    private int lockTimeoutSeconds = 30;

    public ForUpdateBackedRegisterExecutionLock(PlatformTransactionManager transactionManager, PluginMapper pluginMapper, String name) {
        this.transactionManager = transactionManager;
        this.pluginMapper = pluginMapper;
        this.name = name;
    }

    @Override
    public void lock() {
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setTimeout(this.lockTimeoutSeconds);
        TransactionStatus transaction = this.transactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
        RegisterTransactionUtil.set(transaction);
        this.pluginMapper.selectByNameForUpdate(this.name);
    }

    @Override
    public void unlock() {
        TransactionStatus transactionStatus = RegisterTransactionUtil.get();
        try {
            if (transactionStatus.isRollbackOnly()) {
                this.transactionManager.rollback(transactionStatus);
                return;
            }
            this.transactionManager.commit(transactionStatus);
        }
        finally {
            RegisterTransactionUtil.remove();
        }
    }

    public int getLockTimeoutSeconds() {
        return this.lockTimeoutSeconds;
    }

    public void setLockTimeoutSeconds(int lockTimeoutSeconds) {
        this.lockTimeoutSeconds = lockTimeoutSeconds;
    }
}

